/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.82
   Wed Apr 24 1991

   jonathan@Think.COM

*/

#define _C_QREAD

#include "xwais.h"

short readRect(question, file)
Question question;
FILE *file;
{
  char temp_string[MAX_SYMBOL_SIZE];
  char filename[MAX_SYMBOL_SIZE];
  short check_result;
  long left, right, top, bottom;

  check_result = CheckStartOfStruct("rect", file);
  if(FALSE == check_result){ 
    return(false);
  }
  if(END_OF_STRUCT_OR_LIST == check_result)
    {
      return(FALSE);
    }
    
  /* read the slots: */
  while(TRUE){
    long val;
    short check_result = ReadSymbol(temp_string, file, MAX_SYMBOL_SIZE);
    if(END_OF_STRUCT_OR_LIST == check_result) break;
    if(FALSE == check_result){
      return(false);
    } 
    if(0 == strcmp(temp_string, ":left")) {
      if (FALSE == ReadLong(file, &left))
	return(false);
    }
    else if(0 == strcmp(temp_string, ":right")) {
      if (FALSE == ReadLong(file, &right))
	return(false);
    }
    else if(0 == strcmp(temp_string, ":top")) {
      if (FALSE == ReadLong(file, &top))
	return(false);
    }
    else if(0 == strcmp(temp_string, ":bottom")) {
      if (FALSE == ReadLong(file, &bottom))
	return(false);
    }
    else
      return(false);
  }
  return(TRUE);
}

short ReadQuestion(question, file)
Question question;
FILE *file;
{
  char temp_string[MAX_SYMBOL_SIZE];
  char filename[MAX_SYMBOL_SIZE];
  short check_result;

  long version, view;

  /* make sure it's a question */
  
  check_result = CheckStartOfStruct("question", file);
  if(FALSE == check_result){ 
    return(false);
  }
  if(END_OF_STRUCT_OR_LIST == check_result)
    {
      return(FALSE);
    }
    
  /* read the slots: */
  while(TRUE){
    long val;
    short check_result = ReadSymbol(temp_string, file, MAX_SYMBOL_SIZE);
    if(END_OF_STRUCT_OR_LIST == check_result) break;
    if(FALSE == check_result){
      return(false);
    } 
    if(0 == strcmp(temp_string, ":version")) {
      if(FALSE == ReadLong(file, &version))
	return(false);
      question->version = (short)version;
    }
    else if(0 == strcmp(temp_string, ":view")) {
      if(FALSE == ReadLong(file, &view))
	return(false);
      question->view = view;
    }
    else if(0 == strcmp(temp_string, ":window-size")) {
      if(FALSE == readRect(question, file))
	return(false);
    }
    else if(0 == strcmp(temp_string, ":seed-words")) {
      if(FALSE == ReadString(temp_string, file, MAX_SYMBOL_SIZE))
	return(false);
      strcpy(question->keywords, temp_string);
    }
    else if(0 == strcmp(temp_string, ":relevant-documents")) {
      question->RelevantDocuments = ReadListOfDocuments(file);
    }
    else if(0 == strcmp(temp_string, ":sources")) {
      question->Sources = ReadListOfSources(file);
    }
    else if(0 == strcmp(temp_string, ":result-documents")) {
      question->ResultDocuments = ReadListOfDocuments(file);
    }
    else
      return(false);
  }

  return(TRUE);
}



void WriteQuestion(directory, question, overwrite)
char *directory;
Question question;
Boolean overwrite;
{
  DocList doc;
  SourceList sources;
  char filename[MAX_FILENAME_LEN];
  FILE *fp;
  int i;

  /* if you're using the resource questionName, don't save to a file */

  if(!strcmp(question->name, app_resources.questionName))
    exit(0);

  /* build filename */

  strcpy(filename, directory);
  strcat(filename, question->name);

  /* test to see if it exists */

  if (overwrite == FALSE) 
    if ((fp = fopen(filename, "r")) != NULL) {
      char outstring[STRINGSIZE];
      sprintf(outstring, "File %s exists,\nclick again to overwrite.\n", filename);
      XwaisPrintf(outstring);
      fclose(fp);
      return;
    }
  
  if ((fp = fopen(filename, "w")) == NULL) {
    char outstring[STRINGSIZE];
    sprintf(outstring, "Error opening %s.\n", filename);
    XwaisPrintf(outstring);
    return;
  }
  
  WriteStartOfStruct("question", fp);
  WriteNewline(fp);
  WriteSymbol(":version", fp);
  WriteLong(2
, fp);
  WriteNewline(fp);
  WriteSymbol(":seed-words", fp);
  WriteString(question->keywords, fp);
  WriteNewline(fp);
  WriteSymbol(":relevant-documents", fp);
  WriteNewline(fp);
  WriteStartOfList(fp);
  for(doc = question->RelevantDocuments; doc != NULL; doc = doc->nextDoc)
    WriteDocument(doc->thisDoc, fp);
  WriteEndOfList(fp);
  WriteNewline(fp);
  WriteSymbol(":sources", fp);
  WriteNewline(fp);
  WriteStartOfList(fp);
  for(sources = question->Sources; sources != NULL; sources = sources->nextSource) {
    WriteStartOfStruct("source-id", fp);
    WriteNewline(fp);
    WriteSymbol(":filename", fp);
    WriteString(sources->thisSource->filename, fp);
    WriteNewline(fp);
    WriteEndOfStruct(fp);
  }
  WriteNewline(fp);
  WriteEndOfList(fp);
  WriteNewline(fp);
  WriteSymbol(":result-documents", fp);
  WriteNewline(fp);
  WriteStartOfList(fp);
  for(doc = question->ResultDocuments; doc != NULL; doc = doc->nextDoc)
    WriteDocument(doc->thisDoc, fp);
  WriteEndOfList(fp);
  WriteNewline(fp);
  WriteEndOfList(fp);
  fclose(fp);
  question->modified = FALSE;
}
