/* 
  WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the shell user-interface tools for the WAIS software.
   Do with it as you please.

   jonathan@Think.COM

 * $Log:	waisq.c,v $
 * Revision 1.19  92/02/15  19:47:52  jonathan
 * Added $Log for RCS
 * 
*/

#define MAIN
#include "global.h"
#include "wais.h"

#define WAISQ_DATE "Sat Feb 15 1992"

char* log_file_name = NULL;
FILE* logfile = NULL;



/* change PrintStatus so it prints to a label widget */

void
PrintStatus(str)
char * str;
{


/*
	ac=0;
	XtSetArg(al[ac], XmNlabelString, XmStringCreateLtoR
	   (str, XmSTRING_DEFAULT_CHARSET));  ac++;
	XtSetValues(mxq_status_label, al, ac);
	XmUpdateDisplay(mxq_status_label);
*/
if ( (strncmp(str,"done.",5)==0) || (strncmp(str,"Found",5)==0 ) )
     XtUnmanageChild(work_dialog);
else dialog_work(str);

}



void SetSource(question)
Question question;
{
  SourceList s,prev,first;
  SourceID sid;
  int i=0;


prev=NULL;
while (strlen(sourcenames[i])>0)  {
  sid = (SourceID)s_malloc(sizeof(_SourceID));
  sid->filename=malloc(strlen(sourcenames[i])+2);
  strcpy(sid->filename,sourcenames[i]);
  s = (SourceList)s_malloc(sizeof(_SourceList));
  s->thisSource = sid;
  s->nextSource = NULL;
  if (prev!=NULL) {
     prev->nextSource=s;
     }
  else {
     first=s;
     }
  prev=s;
  i++;
  }

  question->Sources = first;
}

char *
fixdirname(dir)
char *dir;
{
  char *res;

  if(dir[strlen(dir)-1] == '/') res = dir;
  else {
    res = s_malloc(strlen(dir)+2);
    sprintf(res,"%s/", dir);
  }
  return res;
}


/* never called ? */
void update_source_connections(s,d)
SList s, d;
{
  SList t1, t2;

  for(t1 = s; t1 != NULL; t1 = t1->nextSource) {
    for (t2 = d; t2 != NULL; t2 = t2->nextSource) {
      if (strcmp(t1->thisSource->server, t2->thisSource->server) == 0 &&
	  strcmp(t1->thisSource->service, t2->thisSource->service) == 0) {
	t2->thisSource->connection = t1->thisSource->connection;
	t2->thisSource->buffer_length = t1->thisSource->buffer_length;
	t2->thisSource->initp = t1->thisSource->initp;
	if (strcmp(t1->thisSource->name, "ReMoVe") != 0) {
	  s_free(t1->thisSource->name);
	  t1->thisSource->name = s_strdup("ReMoVe");
	}
      }
    }
    if (strcmp(t1->thisSource->name, "ReMoVe") != 0 &&
	t1->thisSource->connection != NULL) {
      close_connection_to_server(t1->thisSource->connection);
      for (t2 = t1->nextSource; t2 != NULL; t2 = t2->nextSource) {
	if (strcmp(t1->thisSource->server, t2->thisSource->server) == 0 &&
	    strcmp(t1->thisSource->service, t2->thisSource->service) == 0)
	  t2->thisSource->connection = NULL;
      }
    }
  }
}


waisq_init()
{
int i;

if (the_Question == NULL)  the_Question = (Question)s_malloc(sizeof(_Question));
else {
    /* Time for a little visit from Victor the Cleaner */
  i = 1;

  }   

}



waisq_main(sdir,cdir,sourcenames,keywords)
char *sdir,*cdir,**sourcenames,*keywords;

{
  Question question;
  char msg[STRINGSIZE];
  char qfilename[10];
  void alarmhandler(),SetCursors();
#ifndef SABER
  char *getenv();
#endif

/*strcpy(command_name,"waisq"); */
strcpy(qfilename,"-");


NumSources = 0;
maxDocs = 100;


      
  if(sdir == NULL) {
    if((sdir = (char *)getenv("WAISSOURCEDIR")) == NULL) {
      sprintf(msg, "%s/wais-sources/", getenv("HOME"));
      sdir = s_strdup(msg);
    }
  }

  if (WaisSourceDir != NULL) {
    cdir = (char *)malloc(strlen(WaisSourceDir) + 8);
    strcpy(cdir,WaisSourceDir);
    }

  sdir = fixdirname(sdir);
  PrintStatus("Loading sources...");
  ReadSourceDirectory(sdir, TRUE);

  if(cdir != NULL) {
    cdir = fixdirname(cdir);
    ReadSourceDirectory(cdir, TRUE);
  }


    question = the_Question;

    question->modified = TRUE;

    question->numsources =
      listlength((List)question->Sources);

    question->numdocs =
      listlength((List)question->RelevantDocuments);

    question->numresdocs =
      listlength((List)question->ResultDocuments);

    if (keywords[0] != 0) {
      strcpy(question->keywords,keywords);
    }
    else {
      question->keywords[0]='\0';
    }


    if (sourcenames != NULL) {
      SetSource(question);
    }


      SearchWais(question);

return;

}


MXQShowSearchResults()
{


char *headline;
DocList walking,savewalking;


walking = the_Question->ResultDocuments;
savewalking = walking;

if (walking != NULL) {
	if (mxq_server_responses == NULL) {
               MXQCreateServerResponses();
               }
	}
if (mxq_server_responses != NULL)  ClearHits(XmSelectionBoxGetChild(mxq_server_responses_list,XmDIALOG_LIST));

ClearHeadline(XmSelectionBoxGetChild(mxq_server_responses_list,XmDIALOG_LIST));
while (walking != NULL)  {
    headline=malloc(strlen(walking->thisDoc->doc->headline)+20);
    sprintf(headline,"%4ld  %s",walking->thisDoc->rawScore,walking->thisDoc->doc->headline);
    AddHeadline(headline);
    free(headline);
    walking = walking->nextDoc;
    }
ShowHeadline(XmSelectionBoxGetChild(mxq_server_responses_list,XmDIALOG_LIST));

if (savewalking != NULL) {
    XtRealizeWidget(mxq_server_responses);
   }
else {
   /* Put code here to make and pop up a no-answers dialog */
   }

}



void MXQDisplayDoc(document_number)
int document_number;
{

  Question question;


    question = the_Question;

    if((document_number > 0) && (document_number <= question->numresdocs)) {	/* view a document */
      DocumentID doc;
      
      if((doc = findDoc(question->ResultDocuments, document_number-1))
	 == NULL) {
	print_dialog_err("Unable to find document.  This should not happen.\n");
	return;
      }
/*      fprintf(stderr,"Type is %s\n",doc->doc->type);     */
/*      fprintf(stderr,"source is %s\n",doc->doc->source); */
      ViewWaisDocument(question, doc);
    }
}


void MXQAddRelevant(wdgt,docnum)
Widget wdgt;
int docnum;
{

Question question;
DocList relevant_tail_ptr;
DocList copy_from;
DocList new_tail;
int i;
Boolean replaceHead = False;


question = the_Question;

copy_from = question->ResultDocuments;
for (i=1; i<docnum; i++) {
   copy_from = copy_from->nextDoc;
   }


relevant_tail_ptr = question->RelevantDocuments;
if (relevant_tail_ptr == NULL) {
   replaceHead = True;
   }
else {
   while (relevant_tail_ptr->nextDoc !=NULL) {
      relevant_tail_ptr = relevant_tail_ptr->nextDoc;
      }
   }

/* Now, relevant_tail_ptr *IS* the pointer to the NULL @ the end of the list */
new_tail = (DocList)malloc(sizeof(_DocList));
new_tail->nextDoc = NULL;
/* new_tail->thisDoc = (DocumentID)malloc(sizeof(_DocumentID)); */
new_tail->thisDoc = copy_docid(copy_from->thisDoc);

if (replaceHead) {
   question->RelevantDocuments = new_tail;
   question->numdocs=1;
   }
else  {
   relevant_tail_ptr->nextDoc = new_tail;
   question->numdocs++;
   }
AddHit(copy_from->thisDoc->doc->headline, wdgt);
}


void MXQDeleteRelevant(which)
int which;
{

int i;
DocList walker;

if (which==0) {
   /* strange brew */
   return;
   }
if (which==1) {
   the_Question->RelevantDocuments = the_Question->RelevantDocuments->nextDoc;
   return;                                     /* Leaks like a sieve */
   }
walker = the_Question->RelevantDocuments;
for (i=1; i<which-1; i++) {
   walker=walker->nextDoc;
   }
walker->nextDoc = walker->nextDoc->nextDoc;    /* Leaks like a sieve */
}



