/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.8
   Fri Feb  1 1991

   jonathan@Think.COM

*/

#ifndef _H_DOCUMENT
#define _H_DOCUMENT

#include <../ir/docid.h>
#include "SourceID.h"

typedef struct CRetDocument
 { 
   /* instance variables */
   DocID *id;
   SourceID sourceID;
   any*			myConnection;				/* really a ConnectionID but circular includes preclude that */
   long 			numLines;    				/* number of lines in document */
   long 			numChars;   				/* number of characters */
   char 		*blocks,*pendingBlocks; 	/* lists of CLineBlocks */
   long 			best;
   char		*source,*headline,*city,*stock,*company,*industry, *type, *date;
   struct CRetDocument 	*next,*prev; 				/* linked docs if there are any */
   char			*paraStarts;					/* i'th paragraph starts at line paraStarts[i] 
   												   -1 terminated 
   												 */
   
 } _CRetDocument, *CRetDocument;

typedef struct DocumentID {
  DocID *id;
  short rawScore, normalScore;
  long start, end;
  CRetDocument doc;
} _DocumentID, *DocumentID;

typedef struct doclist {
  DocumentID thisDoc;
  struct doclist *nextDoc;
} _DocList, *DocList;

/* functions */

short ReadDocument();
void WriteDocument();
DocList ReadListOfDocuments();
char **buildDocumentItemList();
DocList makeDocList();
CRetDocument MakeNewDocument();
void sort_document_list();
DocList findLast();
DocumentID fillDocumentID();
DocumentID findDoc();
DocumentID copy_docid();
#endif
