/*********************************************************************/
/*
  This file has been hacked on tremendously by:
     Paul Leclerc
     pel@ctron.com

  I have made this file do its printing of error messages, document
  hits, and other misc stuff through functions rather than printing
  out everything via stdout.

  Necessary routines done by external files
    	print_message();	print mesg to mesg window
	AddHit();		add a "hit" to the hitlist
	ClearDocWin( );		clear the document text window
	ClearHits( );		clear the hit list
	PrintDocWin(  );	print the document buffer to the doc window

	
*/
/*********************************************************************/
/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   Brewster@think.com
*/
/*********************************************************************/
/* This is a simple shell user interface for generating wprot packets.
 * -brewster 7/90
 *
 * Important functions:
 *   display_search_response
 *
 */
/*********************************************************************/
#include <ctype.h>
#include <string.h>
#include <ui.h>
#include <sockets.h>
/*********************************************************************/
#define MAX_MESSAGE_LEN 100000
#define CHARS_PER_PAGE 10000 /* number of chars retrieved in each request */

#define WAISSEARCH_DATE "Fri Sep 13 1991"

#define MAX_KEYWORDS_LENGTH 1000
#define MAX_SERVER_LENGTH 1000
#define MAX_DATABASE_LENGTH 1000
#define MAX_SERVICE_LENGTH 1000
#define MAXDOCS 100

/*********************************************************************/

extern char mesgtxt[512];

static  FILE *connection = NULL;

void display_text_record_window();

SearchResponseAPDU  *query_response;
SearchResponseAPDU  *retrieval_response;
WAISSearchResponse  *query_info;

/*********************************************************************/
/* modified from Jonny G's version in ui/question.c */
void showDiags(d)
diagnosticRecord **d;
{
    long i;

    for (i = 0; d[i] != NULL; i++)
    {
	if (d[i]->ADDINFO != NULL)
	{
	    sprintf(mesgtxt, "Code: %s, %s\n", d[i]->DIAG, d[i] ->ADDINFO);
	    print_message( mesgtxt );
	}
    }
}
/*********************************************************************/

/* modified from tracy shen's version in wutil.c
 * displays either a text record of a set of headlines.
 */
void display_search_response(response)
SearchResponseAPDU *response;
{
    WAISSearchResponse  *info;
    long i, k;

    sprintf(mesgtxt, "Search Response:  Number Of Records Returned: %d\n", 
	    response->NumberOfRecordsReturned); 
    print_message( mesgtxt );

    ClearDocWin( );
    ClearHits( );

    if( response->DatabaseDiagnosticRecords != 0 )
    {
	info = (WAISSearchResponse *)response->DatabaseDiagnosticRecords;
	i = 0; 

	if(info->Diagnostics != NULL)
	    showDiags(info->Diagnostics);

	if( info->DocHeaders != 0 )
	{
	    k = 0;
	    while ( info->DocHeaders[k] != 0 )
	    {
		i++;
		sprintf(mesgtxt,"%2d: Score: %5ld, lines:%5ld '%s'", 
			i, (info->DocHeaders[k]->Score),
			info->DocHeaders[k]->Lines,
			trim_junk(info->DocHeaders[k]->Headline));
		AddHit( mesgtxt );
		k++;
	    }
	}
	if( info->ShortHeaders != 0 )
	{
	    k = 0;
	    while ( info->ShortHeaders[k] != 0 )
	    {
		i++;
		sprintf(mesgtxt, "\nShortHeader record %2d, (can't display)",
			i);
		print_message( mesgtxt );
	    }
	}
	if ( info->LongHeaders != 0 )
	{
	    k = 0;
	    while ( info->LongHeaders[k] != 0 )
	    {
		i++;
		sprintf(mesgtxt, "\nLongheader record %2d, (can't display)\n",
			i);
		print_message( mesgtxt );
	    }
	}
	if( info->Text != 0 )
	{
	    k = 0;
	    while ( info->Text[k] != 0 )
	    {
		i++;
		sprintf(mesgtxt,"\n    Text record %2d, ", i);
		print_message( mesgtxt );
		display_text_record_window( info->Text[k++], false);
	    }
	}
	if( info->Headlines != 0 )
	{
	    k = 0;
	    while ( info->Headlines[k] != 0 )
	    {
		i++;
		sprintf(mesgtxt,
			"\nHeadline record %2d, (can't display)\n",i);
		print_message( mesgtxt );
	    }
	}
	if( info->Codes != 0 )
	{
	    k = 0;
	    while ( info->Codes[k] != 0 )
	    {
		i++;
		sprintf(mesgtxt,
			"\nCode record %2d, (don't know how to display)\n", i);
		print_message( mesgtxt );
	    }
	}
    }					/* display user info */
}
/*********************************************************************/
/* Almost word for word the same as display_text_record_completely() */
/* except that it prints to a Widget.                                */
/* I also buffer up the characters instead of putting them out one   */
/* by one which was painfully slow.                                  */
/*********************************************************************/
void display_text_record_window(record,quote_string_quotes)
WAISDocumentText *record;
boolean quote_string_quotes;
{
    long count;
    char buffer[MAX_MESSAGE_LEN];
    int  pos;

    pos = 0;
    for(count = 0; count < record->DocumentText->size; count++)
    {
	long ch = (unsigned char)record->DocumentText->bytes[count];
	if( ch == 27)
	{
	    /* then we have an escape code */
	    /* if the next letter is '(' or ')', then ignore two letters */
	    if(record->DocumentText->bytes[count + 1] == '(' ||
	       record->DocumentText->bytes[count + 1] == ')' )
		count += 1;             /* it is a term marker */
	    else
		count += 4;		/* it is a paragraph marker */
	}
	else if(ch == '\t')		/* a TAB! */
	{
	    buffer[pos] = ch;
	    pos++;
	}
	else if(isprint(ch))
	{
	    if(quote_string_quotes && ch == '"')
	    {
		buffer[pos] = '\\';
		pos++;
	    }
	    buffer[pos] = ch;
	    pos++;
	} 
	else if( (ch == '\n') || (ch == '\r') )
	{
	    buffer[pos] = '\n';
	    pos++;
	}
    }

    buffer[pos] = '\0';
    PrintDocWin( buffer );
}

/*********************************************************************/
void PerformSearch(server, database, query, service,maxdocs)
char	*server;
char	*database;
char	*query;
int	service;
{
    char* request_message = NULL;	/* arbitrary message limit */
    char* response_message = NULL;	/* arbitrary message limit */
    long request_buffer_length;		/* how of the request is left */

    long count;

    if(!server)
    {
	connection = NULL;
	print_message("No server defined\n");
	return;
    }
    else if ((connection=connect_to_server(server,service)) == NULL) 
    {
	sprintf (mesgtxt, "Error opening connection to %s via service %d.\n",
		 server, service);
	return;
    }

    request_message = (char*)s_malloc((size_t)MAX_MESSAGE_LEN * sizeof(char));
    response_message = (char*)s_malloc((size_t)MAX_MESSAGE_LEN * sizeof(char));

    request_buffer_length = MAX_MESSAGE_LEN;   /* how of the request is left */
    if(generate_search_apdu(request_message + HEADER_LENGTH, 
			    &request_buffer_length, 
			    query, database, NULL, maxdocs) == NULL)
    {
	print_message("Request too large!\n");
	return;
    }
       
    if( interpret_message(request_message,
			  MAX_MESSAGE_LEN - request_buffer_length, 
			  response_message, MAX_MESSAGE_LEN,
			  connection,false) == 0)
    {
	print_message("Returned message too large\n");
	return;
    }

    readSearchResponseAPDU(&query_response, response_message + HEADER_LENGTH);
    display_search_response(query_response);

    query_info =
	(WAISSearchResponse *)query_response->DatabaseDiagnosticRecords;

    s_free(request_message);
    s_free(response_message);
}
/*********************************************************************/
/*
 * Display a given document given the document number.
 * Sends a request to the server for the document
 */
/*********************************************************************/
DisplayDocNum( document_number,db)
int	document_number;
char *db;
{
    int	count;
    int request_buffer_length;
    char *request_message;
    char *response_message;
    
    ClearDocWin( );

    request_message = (char*)s_malloc((size_t)MAX_MESSAGE_LEN * sizeof(char));
    response_message = (char*)s_malloc((size_t)MAX_MESSAGE_LEN * sizeof(char));

#ifdef DODEBUG
    printf("Headline: %s\n", 
	   query_info->DocHeaders[document_number - 1]->Headline);
#endif

    /* we must retrieve the document in parts since it might be very long*/
    for(count = 0; 
	count * CHARS_PER_PAGE <
	query_info->DocHeaders[document_number - 1]->DocumentLength; count++)
    {
	char *type;
	if(query_info->DocHeaders[document_number - 1]->Types == NULL)
	    type = s_strdup("TEXT");
	else
	    type = s_strdup(query_info->DocHeaders[document_number - 1]->Types[0]);
	request_buffer_length = MAX_MESSAGE_LEN; /* length of request left */
	if(0 ==
	   generate_retrieval_apdu(request_message + HEADER_LENGTH,
				   &request_buffer_length, 
				   query_info->DocHeaders[document_number - 1]->DocumentID, 
				   CT_byte,
				   count * CHARS_PER_PAGE,
				   MIN((count + 1) * CHARS_PER_PAGE,
				       query_info->DocHeaders[document_number - 1]->DocumentLength),
				   type,
				   db))
	    panic("request too long");
	     
	if(0 ==
	   interpret_message(request_message, 
			     MAX_MESSAGE_LEN - request_buffer_length, 
			     response_message,
			     MAX_MESSAGE_LEN,
			     connection,
			     false	/* true verbose */	
			     ))
	    panic("Returned message too large");

	readSearchResponseAPDU(&retrieval_response, 
			       response_message + HEADER_LENGTH);

	/* display_search_response(retrieval_response); the general thing */
	if(NULL == ((WAISSearchResponse *)retrieval_response->DatabaseDiagnosticRecords)->Text){
	    display_search_response(retrieval_response);
	    panic("No text was returned");
	}
	display_text_record_window
	    (((WAISSearchResponse *)retrieval_response->DatabaseDiagnosticRecords)->Text[0], false);
    }

    freeWAISSearchResponse( retrieval_response->DatabaseDiagnosticRecords); 
    freeSearchResponseAPDU( retrieval_response);
    s_free(request_message);
    s_free(response_message);
}
/*********************************************************************/
CleanupSearch( )
{
    close_connection(connection);

    freeWAISSearchResponse(query_response->DatabaseDiagnosticRecords);         
    freeSearchResponseAPDU( query_response);

}
/*********************************************************************/
