######################### -*- Mode: Perl -*- #########################
##
## File          : $Basename: Linear.pm $
##
## Author        : Norbert Goevert
## Created On    : Thu Dec 10 15:29:33 1998
## Last Modified : Time-stamp: <2000-11-15 14:59:47 goevert>
##
## Description   : LSP apporach for linear functions
##
## $Id: Linear.pm 1.3 Wed, 15 Nov 2000 23:09:09 +0100 goevert $
## $ProjectHeader: LSP 2.6 Wed, 29 Nov 2000 09:57:57 +0100 goevert $
##
######################################################################


use strict;


=pod #---------------------------------------------------------------#

=head1 NAME

LSP::Linear - LSP apporach for linear functions

=head1 SYNOPSIS

  require LSP::Linear;
  $LSP = new LSP $relevancescale, $dimension;

=head1 DESCRIPTION

LSP::Binary implements the LSP approach for linear regression
functions. See LSP(3) for further documentation. The only difference
is that a polynomial structure must not be specified within the
constructor. It is set to a linear one: for each dimension in your
description vector you'll get one linear component plus a constant one
for normalisation purposes.

=head1 METHODS

See LSP(3).

=cut #---------------------------------------------------------------#


package LSP::Linear;


use base qw(LSP);


our $VERSION;
'$ProjectVersion: 2.6 $ ' =~ /(\d+)\.(\d+)/; $VERSION = sprintf '%d.%03d', $1, $2;


## public ############################################################

sub new {

  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = $class->SUPER::new(@_);

  bless($self, $class);

  return $self;
}


sub add_vector {

  my $self = shift;
  my($vector, $judge, $scalar) = @_;

  return $self->_fail("Wrong dimension of vector ( @$vector ).")
    if @$vector ne $self->{dimension};

  my $vec_vy  = new Math::Matrix [ 1, @$vector, @$judge ];
  my $vec_v_t = (new Math::Matrix [ 1, @$vector ])->transpose;
  my $product = $vec_v_t->multiply($vec_vy);

  if (not defined $scalar or $scalar == 1) {
    $self->{momental}->add_to($vec_v_t->multiply($vec_vy));
  } elsif ($scalar != 0) {
    $self->{momental}->add_to($vec_v_t->multiply($vec_vy)->scalarproduct($scalar));
  }
}


## private ###########################################################


=pod #---------------------------------------------------------------#

=head1 BUGS

Yes. Please let me know!

=head1 SEE ALSO

LSP::Linear(3),
LSP::Binary(3),
LSP::Binary::Linear(3),
Math::Matrix(3),
perl(1).

=head1 AUTHOR

Norbert GE<ouml>vert E<lt>F<goevert@ls6.cs.uni-dortmund.de>E<gt>

=cut #---------------------------------------------------------------#


1;
__END__
