// WaisQuestion.h
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.
// Incorporating:
/* 
   WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the [NeXTstep] user-interface for the WAIS software.
   Do with it as you please.

   Version 0.82
   Wed Apr 24 1991

   jonathan@Think.COM

*/
//
// The main method here is -search:, which returns a List of WaisDocuments (the
// -resultList) upon successful search.  These results are sorted in decreasing
// order of scores, which are normalized to the range 0.0 to 1.0.  The scores 
// can be retrieved with the -scoreForDocument: method.
//

#import "Wais.h"

extern _WaisDecoder waisRectDecoder[], waisQuestionDecoder[];

@interface WaisQuestion : Wais
{
    id sourceList;
    id relevantList;
    id resultList;
    id scoreList;
    unsigned int searchLimit;
    int listCounter;
}

// Access by string keys.
+ folderList;
+ setFolderList:aList;
+ (const char *)defaultHomeFolder;

// Creating and destroying questions.
+ initialize;
- initKey:(const char *)aKey;
- free;

// Setting up for search.
// The actual maximum number of search results is the max of the
// class-wide and instance-specific searchLimits.
// Instance-specific search limits are initialized to one.
- setKeywords:(const char *)theText;
- (const char *)keywords;
- addSource:waisSource;
- removeSource:waisSource;
- clearSources;
- sourceList;
- addRelevantDocument:waisDocument;
- removeRelevantDocument:waisDocument;
- clearRelevantDocuments;
- relevantList;
- setSearchLimit:(int)maxDocs;
- (int)searchLimit;
+ setSearchLimit:(int)maxDocs;
+ (int)searchLimit;

// Getting search results.
// It would be nicer to have retrieve-time selection of formats...
- search;
- resultList;
- (float)scoreForDocument:waisDocument;
+ preferDocumentType:(const char *)waisType withRank:(unsigned int)rank;
+ (const char *)preferredDocumentTypeFrom:(const char *const *)typeList;

// Routing error messages.
+ (const char *)errorTitle;

// Reading/writing WAIS files.
- writeWaisFile;
- (short)readWaisStruct:(const char *)structName
    forElement:(const char *)elementName
    fromFile:(FILE *)file
    withDecoder:(WaisDecoder)theDecoder;
- (short)writeWaisStruct:(const char *)structName
    forElement:(const char *)elementName
    toFile:(FILE *)file
    withDecoder:(WaisDecoder)theDecoder;
+ (const char *)fileStructName;
+ (WaisDecoder)fileStructDecoder;
+ (BOOL)checkFileName:(const char *)fileName;

@end

