// BrowserBarChart.m
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.

#import "BrowserBarChart.h"
#import "BarChartCell.h"

@implementation BrowserBarChart

- initFrame:(const NXRect *)frameRect
{
    return [super initFrame:frameRect cellClass:[BarChartCell class]];
}

- setBarValue:(float)aValue at:(int)row
{
    return [[self cellAt:row] setBarValue:aValue];
}

- (float)barValueAt:(int)row
{
    id cell;
    
    if(!(cell = [self cellAt:row])) return 0.0;
    return [cell barValue];
}

@end

