// BrowserAssocTable.m
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.

#import "BrowserAssocTable.h"
#import "AssocTableCell.h"

@implementation BrowserAssocTable

- initFrame:(const NXRect *)frameRect
{
    return [super initFrame:frameRect cellClass:[AssocTableCell class]];
}

- setAssocStringValue:(const char *)aString at:(int)row
{
    return [[self cellAt:row] setAssocStringValue:aString];
}

- (const char *)assocStringValueAt:(int)row
{
    id cell;
    
    if(!(cell = [self cellAt:row])) return 0;
    return [cell assocStringValue];
}

@end

