// WaisDocument.h
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.
// Incorporating:
/* 
   WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the [NeXTstep] user-interface for the WAIS software.
   Do with it as you please.

   Version 0.82
   Wed Apr 24 1991

   jonathan@Think.COM

*/
//
// NOTE: There are two local files associated with a WaisDocument.  The
// _contents_ file is that named by the key, which can be any type of file.
// This is the file written by the -retrieve method.  The _WAIS specifications_
// file (a WAIS structured file) has as its name the key with ".wais" appended
// (the string W_D_EXT from Wais.h).  This is the file read/written by the
// -read/writeWaisFile methods. (These associated ".wais" files allow documents
// to be reused in later WAIStation sessions.)  The -initKey:, -setKey:, and
// +objectFor[Complete]Key: methods ignore any terminal ".wais".  The 
// +checkFileName: method requires the ".wais", but that is correct since this 
// method is used to determine which files the -read/writeWaisFile methods can 
// be applied to.
//

#import "Wais.h"

extern _WaisDecoder waisSourceIDDecoder[], waisDocumentDecoder[];
extern _WaisDecoder waisFragmentDecoder[], waisDocumentIDDecoder[];

@interface WaisDocument : Wais
{
    id fromSource; // outlet
    DocID *waisDocID;
    BOOL isRetrieved;
}

// Access by string keys.
+ objectForCompleteKey:(const char *)aKey;
+ folderList;
+ setFolderList:aList;
+ (const char *)defaultHomeFolder;
- setKey:(const char *)aKey;

// Creating and destroying sources.
- free;

// Retrieving from source.
- retrieve;
- (BOOL)isRetrieved;
- setUnretrieved;
- fromSource;
- setFromSource:aSource;
- (DocID *)waisDocID;
- setWaisDocID:(DocID *)theDocID; // must be s_free()-able
- setWaisDocIDFromAny:(any *)docAny;
- setKeyFromInfo; // uses ":headline", ":type", ":filename" info fields

// Routing error messages.
+ (const char *)errorTitle;

// Reading/writing WAIS files.
- readWaisFile;
- writeWaisFile;
- (short)readWaisStruct:(const char *)structName
    forElement:(const char *)elementName
    fromFile:(FILE *)file
    withDecoder:(WaisDecoder)theDecoder;
- (short)writeWaisStruct:(const char *)structName
    forElement:(const char *)elementName
    toFile:(FILE *)file
    withDecoder:(WaisDecoder)theDecoder;
+ (const char *)fileStructName;
+ (WaisDecoder)fileStructDecoder;
+ (BOOL)checkFileName:(const char *)fileName;

@end
