/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   Brewster@think.com
*/

/* header for irtfiles.c */

#ifndef IRTFILES_H
#define IRTFILES_H

#include "cdialect.h"
#include "irfiles.h" /* for database struct */

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

typedef boolean (boolfunc)();
typedef void (voidfunc)();
typedef long (longfunc)();

void index_text_file _AP((char* filename,
			  boolean (*separator_function)(),
			  void (*header_function)(),
			  longfunc *date_function,
			  void (*put_together_header_function)(), 
			  char *type,
			  database* db,
			  boolean check_for_text_file,
			  boolean check_for_file_already_indexed));

boolean directoryp _AP ((char *file));

boolean filep _AP((char* file));

void index_directory _AP ((char *file,
			   boolfunc *separator_function,
			   voidfunc *header_function,
			   longfunc *date_function,
			   voidfunc *finish_header_function, 
			   char *type,
			   database *db,
			   boolean check_for_text_file,
			   boolean check_for_file_already_indexed));

#ifdef __cplusplus
	}
#endif /* def __cplusplus */
#endif /* ndef IRTFILES_H */

