#import <appkit/appkit.h>
#import "PhListener.h"
#import <mach.h>
#import <sys/message.h>
#import <servers/netname.h>
extern port_t name_server_port;
extern id NXResponsibleDelegate();
@implementation  PhListener :Listener
{}
static NXRemoteMethod *remoteMethods = NULL;
#define REMOTEMETHODS 6
+ (void)initialize 
/* */
{
    if (!remoteMethods) {
	remoteMethods =
	(NXRemoteMethod *) malloc((REMOTEMETHODS+1)*sizeof(NXRemoteMethod));
	remoteMethods[0].key = 
	@selector(hide);
	remoteMethods[0].types = "";
	remoteMethods[1].key = 
	@selector(unhide);
	remoteMethods[1].types = "";
	remoteMethods[2].key = 
	@selector(addServer:site:ok:);
	remoteMethods[2].types = "ccI";
	remoteMethods[3].key = 
	@selector(getServers:sites:ok:);
	remoteMethods[3].types = "CCI";
	remoteMethods[4].key = 
	@selector(queryServer:site:command:ok:);
	remoteMethods[4].types = "cccI";
	remoteMethods[5].key = 
	@selector(showServer:site:ok:);
	remoteMethods[5].types = "ccI";
	remoteMethods[REMOTEMETHODS].key = NULL;
    }
}
-(int)hide
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(hide)))
	return [_NXd hide];
    return -1;
}

-(int)unhide
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(unhide)))
	return [_NXd unhide];
    return -1;
}

-(int)addServer : (char *) aServer
	site : (char *) aSite
	ok : (int *) flag
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(addServer:site:ok:)))
	return [_NXd addServer : aServer
		site : aSite
		ok : flag];
    return -1;
}

-(int)getServers : (char **) serverNames
	sites : (char **) siteNames
	ok : (int *) flag
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(getServers:sites:ok:)))
	return [_NXd getServers : serverNames
		sites : siteNames
		ok : flag];
    return -1;
}

-(int)queryServer : (char *) aServer
	site : (char *) aSite
	command : (char *) aCommand
	ok : (int *) flag
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(queryServer:site:command:ok:)))
	return [_NXd queryServer : aServer
		site : aSite
		command : aCommand
		ok : flag];
    return -1;
}

-(int)showServer : (char *) aServer
	site : (char *) aSite
	ok : (int *) flag
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(showServer:site:ok:)))
	return [_NXd showServer : aServer
		site : aSite
		ok : flag];
    return -1;
}

- (int) performRemoteMethod : (NXRemoteMethod *) method
                  paramList : (NXParamValue *) paramList {
/* */
    switch (method - remoteMethods) {
    case 0:
	return [self hide];
    case 1:
	return [self unhide];
    case 2:
	return [self addServer : paramList[0].bval.p
		site : paramList[1].bval.p
		ok : &paramList[2].ival];
    case 3:
	return [self getServers : &paramList[0].bval.p
		sites : &paramList[1].bval.p
		ok : &paramList[2].ival];
    case 4:
	return [self queryServer : paramList[0].bval.p
		site : paramList[1].bval.p
		command : paramList[2].bval.p
		ok : &paramList[3].ival];
    case 5:
	return [self showServer : paramList[0].bval.p
		site : paramList[1].bval.p
		ok : &paramList[2].ival];
    default:
	return [super performRemoteMethod : method paramList : paramList];
    }
}
- (NXRemoteMethod *) remoteMethodFor: (SEL) aSel {
/* */
    NXRemoteMethod *rm;
    if (rm = NXRemoteMethodFromSel(aSel,remoteMethods))
        return rm;
    return [super remoteMethodFor : aSel];
}
@end
