/*
** This software is Copyright (c) 1989, 1990, 1991 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
*/

#if !defined(lint) && !defined(SABER)
static char SID[] = "@(#)str.c	2.1 2/21/91";
#endif

/*
** Strchr() and Strrchr() are included for portability sake only.
*/

#ifndef NULL
#define NULL 0
#endif

#ifndef lint
/*
** strchr:
**
** strchr(str, c) returns a pointer to the first place in
** str where c occurs, or NULL if c does not occur in str.
**
** char *strchr(str, c) char *str, c; { return (str); }
**
*/

char *strchr(str, c)
register char *str, c;
{
    for (;;) {
        if (*str == c)
            return (str);
        if (!*str++)
            return (NULL);
    }
}

/*
** strrchr:
**
** strrchr(str, c) returns a pointer to the last place in 
** str where c occurs, or NULL if c does not occur in str.
**
** char *strrchr(str, c) char *str, c; { return (str); }
*/

char *strrchr(str, c)
register char *str, c;
{
    register char *t;

    t = NULL;
    do {
        if (*str == c)
            t = str;
    } while (*str++);
    return(t);
}
#endif /* lint */

/*
** strstrip:
**
** strstrip(str) returns a pointer to the first non-blank character 
** in str. It strips all blanks, and tabs from the front and back
** of a string as well as strip off newlines from the rear.
**
** char *strstrip(str) char *str; { return (str); }
*/

char *strstrip(str)
register char *str;
{
    int strlen();
    register char *cp, *dp;
    
    cp = str;
    dp = ((str+strlen(str))-1);

    while(*cp && (*cp == ' ' || *cp == '\t')) 
      cp++;

    while(dp != cp && (*dp == ' ' || *dp == '\t' || *dp == '\n'))
      --dp;
    *(dp+1) = '\0';

    return(cp);
}

