/*
** This software is Copyright (c) 1989, 1990, 1991 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
*/
#ifndef lint
static char SID[] = "@(#)disp_grp.c	2.3 5/9/91";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <pwd.h>
#include <grp.h>
#include "rkive.h"

extern fill_in_defaults;
extern FILE *logfp;
extern char log[];
extern char mindex[];
extern char log_format[];
extern char index_format[];
extern char mail[];
extern char compress[];
extern char checkhash[];
extern char arch_command[];

struct passwd *pw;
struct passwd *getpwuid();
struct group *gr;
struct group *getgrgid();

char *what_to_print(ng_val, gbl_val, str)
char *ng_val, *gbl_val, *str;
{
    static char rtbuf[50];

    /*
    ** If the newsgroup variable has been 
    ** specified, return that value.
    */
    if (*(ng_val)) 
        return (ng_val);

    /*
    ** If no global value has been specified
    ** so that there is no default, build the
    ** display string and return.
    */
    if (!*gbl_val) {
        (void) sprintf(rtbuf,"%-15s (*NO* DEFAULT)", str);
        return (rtbuf);
    }

    /*
    ** Ok, here we have a global value.
    ** Check if the user has requested to display global default
    ** values in variables that are not specifically assigned 
    ** for the newsgroup...
    */
    if (fill_in_defaults)
        return (gbl_val);

    (void) sprintf(rtbuf,"%-15s (DEFAULT)", str);
    return (rtbuf);
}


void display_group_info(ng)
struct group_archive *ng;
{
    if (!*ng->location)
       (void) fprintf(logfp,"\007\007%s does not have an archived location\n",
                  ng->ng_name);
    else
       (void) fprintf(logfp,"%s newsgroup archived to %s\n", 
                  ng->ng_name, ng->location);

    (void) fprintf(logfp,"\tArchive Type:        %s\n",
                  ng->type == ARCHIVE_NAME ? "Archive-Name" : 
                  ng->type == VOLUME_ISSUE ? "Volume-Issue" :
                  ng->type == CHRONOLOGICAL ? "Chronological" :
                  ng->type == COMP_ARCHIVES ? "Comp-Archives" :
                  ng->type == ONLY_ARCHIVE_NAME ? "Only-Archive-Name":
                  ng->type == EXTERNAL_COMMAND ? "External-Command" :
                                             "Article-Number"); 
    if (ng->type == EXTERNAL_COMMAND) {
       /* Must have an ARCHIVE_CMD line... */
       (void)fprintf(logfp,"\tArchive Command:     %-15s\n",
                  *ng->arch_command != '\0' ? ng->arch_command : 
                  !*arch_command ? "ERROR - (*NO* DEFAULT)" :
                  fill_in_defaults ? arch_command : "NOT SPECIFIED (DEFAULT)");
    }

    (void) fprintf(logfp,"\tPatches Type:        %s\n", 
                  ng->patch_type == PACKAGE ? "Package" : "Historical");

    /* 
    ** The getpwuid() and getgrgid() calls have been previously made
    ** thus verifying the entries exist. No real reason to check if
    ** calls fail. If they do, something a lot bigger than this program
    ** is hosed...
    */
    pw = getpwuid(ng->owner);
    (void) fprintf(logfp,"\tOwner:               %d <%s>\n", 
                  ng->owner, pw->pw_name);
    gr = getgrgid(ng->group);
    (void) fprintf(logfp,"\tGroup:               %d <%s>\n", 
                  ng->group, gr->gr_name);

    (void) fprintf(logfp,"\tFile Modes:          %o\n", ng->modes);
    (void) fprintf(logfp,"\tLogfile:             %s\n", 
               what_to_print(ng->logfile, log, "NO LOGGING"));
    (void) fprintf(logfp,"\tIndex File:          %s\n", 
               what_to_print(ng->index, mindex, "NO INDEXING"));
    if (*ng->arc_done)
        (void) fprintf(logfp,"\t.archived File:      %s\n", ng->arc_done);
    if (*ng->patchlog)
        (void) fprintf(logfp,"\t.patchlog File:      %s\n", ng->patchlog);
    (void) fprintf(logfp,"\tLogfile Format:      %s\n", 
               what_to_print(ng->logformat, log_format, "NOT SPECIFIED"));
    (void) fprintf(logfp,"\tIndex Format:        %s\n", 
               what_to_print(ng->indformat, index_format, "NOT SPECIFIED"));
    (void) fprintf(logfp,"\tMail Results:        %s\n", 
               what_to_print(ng->mail_list, mail, "NO ONE"));
    (void) fprintf(logfp,"\tCompression:         %s\n", 
               what_to_print(ng->compress, compress, "NO COMPRESSION"));
    (void) fprintf(logfp,"\tChecksum:            %s\n", 
               what_to_print(ng->checkhash, checkhash, "NO CHECKHASH"));
#ifdef NNTP
    if (*ng->nntp)
        (void) fprintf(logfp,"\tNNTP Archiving From: %s\n", ng->nntp);
    else
        (void) fprintf(logfp,"\tArchiving From:      LOCAL DISK\n");
#endif /*NNTP*/

    if ((ng->patch_type == PACKAGE) && (ng->type != ARCHIVE_NAME)) {
        (void) fprintf(logfp,"\nWARNING: Package Patches archiving is only\n");
        (void) fprintf(logfp,"         used with Archive-Name archiving.\n");
    }
}
