/*
** This software is Copyright (c) 1989, 1990, 1991 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
*/
#if !defined(lint) && !defined(SABER)
static char SID[] = "@(#)ck_name.c	2.2 2/23/91";
#endif

#include <stdio.h>
/*
** check_archive_name
**
** Assure the path specified is within the base directory
** specified by the archive administrator by assuring that
** a prankster could not have an article archived at a
**     basedir/../../../etc/passwd
** location.
**
** If an absoulte path is specified in the Archive-name, it
** is of no concern since a "checked" base directory and
** volume directory are prefixed.
*/

void check_archive_name(argstr)
    char *argstr;
 {
    int strlen();
    char *substr();
    register char *rp;
    register char *dp;

    /* 
    ** check to assure that the path specified
    ** does not contain the '..' sequence.
    */

    while ((rp = substr(argstr, "..")) != NULL) {
       dp = rp+2;
       while(*dp)
           *rp++ = *dp++;
       *rp = '\0';
    }

    /* I know this is not necessary but what the heck.. */

    while ((rp = substr(argstr, "//")) != NULL) {
       dp = rp+2;
       ++rp;
       while(*dp)
           *rp++ = *dp++;
       *rp = '\0';
    }

    /* 
    ** strip the string of trailing '/'s
    */

    dp = argstr+(strlen(argstr)-1);
    while(*dp == '/' && dp > argstr)
        *dp = '\0';

    /*
    ** Assure that there is no spaces inside
    ** the archive-name. This is not that uncommon
    ** alt.sources postings. "X_list/part 3"
    */

    rp = argstr;
    while (*rp) {
       if (*rp == ' ')
           *rp = '-';
       ++rp;
    }

    /*
    ** lets get rid of leading blanks so
    ** that "/dev/null" Archive-name: lines
    ** work as they should... :-)
    */

    dp = argstr;
    rp = argstr;

    while(*dp == '/')
        ++dp;

    while(*dp)
      *rp++ = *dp++;
    *rp = '\0';
}
