/*
** 	@(#)article.h	2.4 4/15/92
**
*/

#define BUFLEN    128    /* standard buffer size                     */
#define LBUFLEN  1024    /* big buffer size                          */
#define PATHLEN   512    /* length of longest source string          */
#define DATELEN    64    /* length of longest allowed date string    */

#ifndef TRUE
# define TRUE        1    
#endif

#ifndef FALSE
# define FALSE       0    
#endif

/*
** Line content defines
*/
#define BLANK 0
#define TEXT  1

/*
** Format output called from defines 
*/
#define ARCHIVE     1
#define ARTICLE     2

/*
** Line type defines -  index uses
*/

#define FROM            	1
#define PATH            	2
#define NEWSGROUP       	3
#define SUBJECT         	4
#define MSG_ID	        	5
#define REPLY_TO        	6
#define REFERENCES      	7
#define DATE            	8
#define EXPIRE          	9
#define CONTROL        		10
#define SENDER         		11
#define FOLLOWUP_TO    		12
#define DISTRIBUTION   		13
#define ORGANIZATION   		14
#define NUMLINES       		15
#define KEYWORDS       		16
#define SUMMARY        		17
#define APPROVED       		18
#define SUPERSEDES     		19
#define XREF           		20
#define POSTING_NUMBER 		21
#define SUBMITTED_BY   		22
#define ARCH_NAME      		23
#define ARTICLEID      		24
#define PATCH_TO       		25
#define X_CHECKSUM        	26
#define ORIGINAL_POSTING_BY	27
#define ORIGINAL_SUBJECT	28
#define ARCHIVE_SITE		29
#define ARCHIVE_DIRECTORY	30
#define REPOSTED_BY		31
#define VERSION_NUMBER		32
#define ARCHITECTURE		33
#define ARCHIVE_                34
#define ENVIRONMENT             35
#define OTHER          		99

/* 
** article header storage structure
*/

#define MAX_HEADERS    36 /* No 'other' here! */


struct    header {
    char    from[BUFLEN];         	/* From:                 */
    char    path[PATHLEN];        	/* Path:                 */
    char    nbuf[LBUFLEN];        	/* Newsgroups:           */
    char    subject[BUFLEN];      	/* Subject:              */
    char    ident[BUFLEN];        	/* Message-ID:           */
    char    replyto[BUFLEN];      	/* Reply-To:             */
    char    references[BUFLEN];   	/* References:           */
    char    subdate[DATELEN];     	/* Date: (submission)    */
    time_t  subtime;              	/* subdate in secs       */
    char    expdate[DATELEN];     	/* Expires:              */
    char    ctlmsg[PATHLEN];      	/* Control:              */
    char    sender[BUFLEN];       	/* Sender:               */
    char    followup_to[BUFLEN];  	/* Followup-to:          */
    char    distribution[BUFLEN]; 	/* Distribution:         */
    char    organization[BUFLEN]; 	/* Organization:         */
    char    numlines[8];          	/* Lines:                */
    int     intnumlines;          	/* Integer version       */
    char    keywords[BUFLEN];     	/* Keywords:             */
    char    summary[BUFLEN];      	/* Summary:              */
    char    approved[BUFLEN];     	/* Approved:             */
    char    xref[BUFLEN];         	/* Xref:                 */
    char    supersedes[BUFLEN];   	/* Supersedes:           */
    char    submitted_by[BUFLEN]; 	/* Submitted_by:         */
    char    posting_num[BUFLEN];  	/* Posting-number:       */
    char    archive_name[BUFLEN]; 	/* Archive-name:         */
    char    patch_to[BUFLEN];     	/* Patch-To:             */
    char    x_checksum[BUFLEN];		/* X-Checksum-Snefru: or */
                               		/* X-Md4-Signature:  	 */
    char    orig_poster[BUFLEN];	/* Original-posting-by:  */
    char    orig_subject[BUFLEN];	/* Original-subject:     */
    char    archive_site[BUFLEN];	/* Archive-site:         */
    char    archive_dir[BUFLEN];	/* Archive-Directory:    */
    char    reposter[BUFLEN];    	/* Reposted-by:          */
    char    version_number[BUFLEN];	/* Version-number:       */
    char    architecture[BUFLEN];    	/* Architecture:         */
    char    archive[BUFLEN];		/* Archive:		 */
    char    environment[BUFLEN];	/* Environment:		 */
    char header[MAX_HEADERS][BUFLEN];   /* Index with header-codes */

};

/*
** Type of archive file defines
*/
#define NORMAL         0
#define INFORMATIONAL  1
#define PATCH          2
#define ADMINISTRATION 3

/* 
** archive information structure
*/

struct archive_rec {
    char newsgroup[LBUFLEN];      /* news group            */
    char newsarticle[LBUFLEN];    /* news article          */
    char filename[BUFLEN];        /* destination file      */
    int  volume;                  /* storage volume        */
    int  issue;                   /* article issue number  */
    int  rectype;                 /* type of article       */
                                  /*   NORMAL article =  0 */
                                  /*   INFORMATIONAL  =  1 */
                                  /*   PATCH          =  2 */
                                  /*   ADMINISTRATION =  3 */
    int  repost;                  /* REPOST'ed article ?   */
    int  patch_volume;            /* Initially posted      */
                                  /*   storage volume      */
    char package_name[BUFLEN];    /* Initially posted      */
    char patch_issue[BUFLEN];     /* Initially posted      */
                                  /* article issue numbers */
    char description[BUFLEN];     /* information           */
    char author_name[BUFLEN];     /* author full name      */
    char author_signon[BUFLEN];   /* author sign on        */
};

extern FILE *logfp;

#ifndef ARTICLE_DEF
#define ARTICLE_DEF 1
    struct archive_rec article;
    struct header header;
    char s[BUFSIZ];
    int debug;
    int verbose;
#else
    extern char s[];
    extern int debug;
    extern int verbose;
    extern struct archive_rec article;
    extern struct header header;
#endif /* ARTICLE_DEF */
