/*
 * recnotes [to notesgroup]
 *
 * Process a notes article which has been mailed to some group like msgs.
 * Such articles are in normal mail format and have never seen the insides
 * of netnotes.  If the "to notesgroup" is included, the article is posted
 * to this notesgroup instead of trying to intuit it from the headers.
 * If the "from user" is included, the return address is forged to look
 * like that user instead of what getuid or a from line says.
 *
 * It is recommended that you always include the to notesgroup, since the
 * intution code is flakey and out of date.  The from user is probably
 * appropriate for arpanet mailing lists being funnelled at ucbvax but
 * not otherwise.  Sample lines in /usr/lib/aliases (if you run delivermail):
 *	worldnotes: "|/usr/lib/notes/recnotes net.general"
 *		Allows you to mail to worldnotes rather than using inotes.
 *		Intended for humans to mail to.
 *	post-unix-wizards: "|/usr/lib/notes/recnotes fa.unix-wizards unix-wizards"
 *		Causes mail to post-unix-wizards to be fed into fa.unix-wizards
 *		and the return address forged as unix-wizards on the local
 *		machine.  post-unix-wizards (on the local machine) should
 *		be part of the master mailing list somewhere (on a different
 *		machine.)
 *
 * Recnotes is primarily useful in remote places on the usenet which collect
 * mail from mailing lists and funnel them into the network.  It is also
 * useful if you like to send mail to some user instead of invoking
 * inotes -t .. -n .. when you want to submit an article.  (Many mailers give
 * you nice facilities like editing the message.)  It is not, however,
 * essential to use recnotes to be able to join usenet.
 *
 */

#ifndef lint
static char	*SccsId = "@(#)recnotes.c	2.9	9/3/84";
#endif !lint

#include "parms.h"
#include "structs.h"

#include <stdio.h>
#include <ctype.h>

/*
 * Note: we assume there are 2 kinds of hosts using recnotes:
 * Those that have delivermail (and hence this program will never
 * have to deal with more than one message at a time) and those on the arpanet
 * that do not (and hence all messages end with a sentenel).  It is
 * supposed that regular v7 type systems without delivermail or some
 * other automatic forwarding device will just use rnotes.  We do
 * not attempt to tell where a message ends on all systems due to the
 * different conventions in effect.  (This COULD be fixed, I suppose.)
 */

/*
 * Kinds of lines in a message.
 */
#define FROM	001		/* From line */
#define SUBJ	002		/* Subject */
#define TO	003		/* To (newgroup based on this) */
#define BLANK	004		/* blank line */
#define EOM	005		/* End of message (4 ctrl A's) */
#define HEADER	006		/* any unrecognized header */
#define STUFF	007		/* anything unrecognized */
#define KEEP	008		/* preserve this header in the body */
#define INCLUSIVE 010		/* notesgroup is already in header */

/*
 * Possible states program can be in.
 */
#define SKIPPING	0100	/* In header of message */
#define READING		0200	/* In body of message */

#define BFSZ 250
#define KEEPNUM	57		/* varieties of headers to keep */

#define EOT	'\004'

char	from[BFSZ];		/* mailing address for replies */
char	to[BFSZ];		/* Destination of mail (msgs, etc) */
char	subject[BFSZ];		/* subject of message */
char	to_newsgroup[BFSZ];	/* newsgroups of message */
char	cmdbuf[BFSZ];		/* command to popen */
char	keeplist[KEEPNUM][BFSZ]; /* list of headers to keep */

extern	char	*strcat(), *strcpy();
extern	FILE	*popen();
char	*any();

main(argc, argv)
int argc;
char **argv;
{
	char buf[BFSZ], inotes[BFSZ];
	register char *p, *q;
	register FILE *pipe = NULL;
	register int state;

	initenv();

	/* build inotes command */
	sprintf(inotes, "%s/%s", libdir, "inotes");

	if (argc > 1)
		strcpy(to, argv[1]);
#ifdef debug
	printf("argv[0] is <%s>, argv[1] is <%s>, argv[2] is <%s>\n",
		argv[0], argv[1], argv[2]);
#endif
	state = SKIPPING;
	while (fgets(buf, BFSZ, stdin) != NULL) {
		if (state == READING) {
			fputs(buf,pipe);
			continue;
		}
		switch (type(buf)) {

		case FROM:
			frombreak(buf, from);
			break;

		case SUBJ:
			p = any(buf, " \t");
			if (p == NULL)
				p = buf + 8;
			q = subject;
			while (*++p) {
				if (*p == '"')
					*q++ = '\\';
				*q++ = *p;
			}
			q[-1] = '\0';
			break;

		case TO:
			if (to[0])
				break;		/* already have one */
			p = any(buf, " \t");
			if (p == NULL)
				p = buf + 3;
			q = to;
			while (*++p) {
				if (*p == '"')
					*q++ = '\\';
				*q++ = *p;
			}
			q[-1] = '\0';
			break;

		/*
		 * Kludge to compensate for messages without real headers
		 */
		case HEADER:
			break;

		case BLANK:
			state = READING;
			findgroup(to, to_newsgroup);
			sprintf(cmdbuf, "exec %s -t \"%s\" -n \"%s\" -f \"%s\"",
				inotes, subject, to_newsgroup, from);
#ifdef debug
			pipe = stdout;
			printf("BLANK: %s\n", cmdbuf);
#else
			pipe = popen(cmdbuf, "w");
			if (pipe == NULL) {
				perror("recnotes: popen failed");
				exit(1);
			}
#endif
			break;

		case STUFF:
			findgroup(to, to_newsgroup);
			state = READING;
			if (subject[0] == 0) {
				strcpy(subject, buf);
				if (subject[strlen(subject)-1] == '\n')
					subject[strlen(subject)-1] = '\0';
			}
			sprintf(cmdbuf, "exec \"%s\" -t \"%s\" -n \"%s\" -f \"%s\"",
				inotes, subject, to_newsgroup, from);
#ifdef debug
			pipe = stdout;
			printf("STUFF: %s\n", cmdbuf);
#else
			pipe = popen(cmdbuf, "w");
			if (pipe == NULL) {
				perror("pipe failed");
				exit(1);
			}
#endif
			break;
		}
	}
	exit(0);
}

type(p)
register char *p;
{
	char *firstbl;
	static char lasthdr;		/* prev line was a header */

	lasthdr = 1;
	if ((*p == ' ' || *p == '\t') && lasthdr)
		return HEADER;		/* continuation line */
	firstbl = any(p, " \t");
	while (*p == ' ' || *p == '?' || *p == '\t')
		++p;

	if (*p == '\n' || *p == 0)
		return BLANK;
	if (strncmp(p, ">From", 5) == 0 || strncmp(p, "From", 4) == 0)
		return FROM;
	if (strncmp(p, "Subj", 4)==0 || strncmp(p, "Re:", 3)==0 ||
		strncmp(p, "re:", 3)==0)
		return SUBJ;
	if (strncmp(p, "To", 2)==0)
		return TO;
	if (strncmp(p, "\1\1\1\1", 4)==0)
		return EOM;
	if (firstbl && firstbl[-1] == ':' && isalpha(*p))
		return HEADER;
	lasthdr = 0;
	return STUFF;
}

/*
 * Figure out who a message is from.
 */
frombreak(buf, fbuf)
register char *buf, *fbuf;
{
	register char *p = buf;

	p += 4;				/* skip From */
	if (*p == ':')
		p++;
	while (*p == ' ' || *p == '\t')
		p++;
	strcpy(fbuf, p);
	if (fbuf[strlen(fbuf)-1] == '\n')
		fbuf[strlen(fbuf)-1] = '\0';
}

findgroup(dest, group)
char *dest ;
char *group;
{
#ifdef debug
	printf("findgroup(%s)\n", dest);
#endif
#ifdef fussy
	/*
	 * Default unknown "to" fields to "general".  This gives you
	 * tight control over which notesgroups exist.
	 */
	if (strcmp(dest, "msgs")==0)
		strcpy(group, "msgs");
	else if (strcmp(dest, "allmsgs")==0)
		strcpy(group, "NET.allmsgs");
	else if (strcmp(dest, "csmsgs")==0)
		strcpy(group, "NET.csmsgs");
	else
		strcpy(group, "general");
#else
	/*
	 * Allow any notesgroup.  This way you don't have to recompile
	 * recnotes everytime you add a notesgroup.
	 */
	strcpy(group, dest);
#endif
}

/*
 * Return the ptr in sp at which a character in sq appears;
 * NULL if not found
 *
 */

char *
any(sp, sq)
char *sp, *sq;
{
	register c1, c2;
	register char *q;

	while (c1 = *sp++) {
		q = sq;
		while (c2 = *q++)
			if (c1 == c2)
				return(--sp);
	}
	return(NULL);
}
