#ifdef	RCSIDENT
static char rcsid[]="$Header: /user1/staff/gore/exp/notes/src/RCS/newsinput.c,v 1.1 88/04/24 13:59:35 gore Exp $";
#endif	RCSIDENT

/*
 * newsinput.c
 *
 * This program will accept an article according to the news
 * protocol.  The article will then be inserted in
 * the notefile(s) which match the newsgroup(s).  
 */

#include <ctype.h>

#include "parms.h"
#include "structs.h"
#include "header.h"

static char title[TITLEN];			/* title */
static int is_resp;
static long savepos;
static char* fromsys = NULL;	/* We will set this from "Path:", if we can */
static int archive = 0;		/* Treat batch as an archive, i.e., set */
				/* date received from "Date:" line.     */
#ifdef __STDC__
FILE *hread(struct hbuf*, FILE*, int);
#else
FILE *hread();
#endif
char *malloc();
char *index();
long ftell();
long atol();
time_t getdate();

static int num_articles;
static int num_groups;
static int num_duplicates;
static int num_orphans;

#ifdef __STDC__
static void setfromsys(char*);
static int tailmatch(char*,char*);
#else
static void setfromsys();
static int tailmatch();
#endif

static int did_ok = GOOD;

/*
 * driving routine to handle a processed article
 * (all the headers are already in place)
 *
 * The article can be a single article or in batch format
 *
 * We typically receive processed articles from remote systems
 */
main(argc, argv)
char  **argv;
{
	register int c;
	register FILE *fp;
	register long size;
	int bflag = 0;
	char tmpfile[WDLEN];
	char buf[BUFSIZ];
	time_t zaptime;
	long atime;
	int i;

	initenv();

	time (&zaptime);

	if (verbose_log) log("Newsinput started as p=%d",getpid());

	atime = igetconfig ("Junk-Days");
	if (atime == -1)	/* not present, use Archive-Days */
	    atime = igetconfig("Archive-Days");
	if (atime == -1)	/* not present, take the hard default */
	    atime = ARCHTIME;

	if (igetconfig ("Allow-Old"))	{/* zap if either missing or true */
	    if (verbose_mode) printf ("newsinput: not zapping oldnotes\n");
	    zaptime = 0;
	}
	else {
	    zaptime -= (long) atime * DAYSECS;
	    if (verbose_mode)
	        printf ("newsinput: zapping oldnotes\n");
	}

	/*
	 * COMMAND LINE DECODER
	 */
	for (i = 1; i < argc; i++)
	if (argv[i][0] == '-') {		/* option */
		switch (argv[i][1]) {
		case 'A': 			/* reading archive batch */
			archive = 1;
			zaptime = 0;		/* allow old notes */
			break;

		default: 
			printf("Bad switch `%c'\n", argv[i][1]);
			usage (argv[0]);
			cleanup(BAD);
		}
	} else {
		printf("Bad switch `%c'\n", argv[i][1]);
		usage (argv[0]);
		cleanup(BAD);
	}

	/* if first character is a #, we assume the batch format */
	c = getc(stdin);
	if (c != EOF)
		ungetc(c, stdin);
	clearerr(stdin);
	if (c == '#')
		bflag++;

	/* copy article to tmp file and process it */
	sprintf(tmpfile, "%s/nfbnewsXXXXXX", TMPDIR);
	mktemp(tmpfile);
	if (bflag) {
		/* B news batch format */
		while (fgets(buf, sizeof buf, stdin)) {
			if (strncmp(buf, "#! rnews ", 9) != 0)
				continue;
			size = atol(&buf[9]);
			if (size <= 0)
				break;
			if ((fp = fopen(tmpfile, "w")) == NULL) {
				log("newsinput: can not open %s", tmpfile);
				exit(91); /* exit(BAD); */
			}
			while (--size >= 0 && (c = getc(stdin)) != EOF)
				putc(c, fp);
			fclose(fp);
			/* only process untruncated articles */
			if (size > 0)
				break;
			proc2(tmpfile, zaptime);
		}
	} else {
		/* simple article */
		if ((fp = fopen(tmpfile, "w")) == NULL) {
			log("newsinput: can not open %s", tmpfile);
			exit(92); /* exit(BAD); */
		}
		while ((c = getc(stdin)) != EOF)
			putc(c, fp);
		fclose(fp);
		proc2(tmpfile, zaptime);
	}
	unlink(tmpfile);
	if (fromsys != NULL) {
		log("Inserted %d articles into %d groups from %s",
			num_articles, num_groups, fromsys);
		/* log("Dropped %d articles from %s", ???, fromsys); */
	} else {
		log("Inserted %d articles into %d groups",
			num_articles, num_groups);
		/* log("Dropped %d articles from %s", ???, fromsys); */
	}
	exit(did_ok);
}

static struct hbuf hb;

/*
 * a processed message is in a file
 * get the header and process each notesfile in turn.
 */
proc2(file, zaptime)
	char *file;
	time_t zaptime;
{
	FILE *rawnews;
	struct hbuf *hp = &hb;
	int i, c;
	struct io_f io;
	char nf[NNLEN];				/* the notefile */
	char ngroup[NUMGROUPS][WDLEN];		/* newsgroups name */
	int numgroups;			/* number of groups to post to */
	char line[1024];		/* scratch */
	char line2[1024];
	char *p, *q;
	int errs, status, ret, has_suffix;

	num_articles++;

	/* open up the article */
	if ((rawnews = fopen(file, "r")) == NULL) {
		log("newsinput: can not process %s", file);
		did_ok = BADFORMAT;
		return;
	}
	/* Parse the header */
	if (hread(&hb, rawnews, TRUE) == NULL) {
		log("newsinput: %s garbled header, article number %d in batch",
		    hb.ident, num_articles);
		did_ok = BADFORMAT;
		return;
	}
	hp = &hb;

	savepos = ftell(rawnews);

	/* If we don't have a source system yet, get one */
	if (fromsys == NULL)
	        setfromsys(hp->path);

	/* strip "Re:" and "- (nf)", set title global buffer */
	/* if it has "Re:" we assume it's a response */
	is_resp = gettitle(hp->title, &has_suffix);
	if(strlen(hp->followid) != 0)
	  is_resp = 1;		/* if it's got "References:", it's a resp */
	
	
	/* check if this is a notes generated article */
	/*  ---- status is never used! ---- */
	/* status = isnotes(hp, rawnews, has_suffix); */

	/* get the date */
	hp->subtime = getdate(hp->subdate, NULL);

	/* If we are restoring from an archive batch, lets pretend */
	/* that we received this at the time it was posted, rather */
	/* than today. */
	if(archive)
	  hp->rectime = hp->subtime;
	else
	  time(&hp->rectime);

	if (hp->subtime < 0) {
	    /*
	     * getdate() could not parse the date and returned -1.
	     * Just set it to the received time.
	     */
	    hp->subtime = hp->rectime;
	}

	/* get the newsgroups */
	p = hp->nbuf; 
	numgroups = 0;
	errs = 0;
	while (numgroups < NUMGROUPS) {
		while (*p == ' ' || *p == '\t' || *p == NGDELIM)
			p++;
		if (*p == 0)
			break;
		q = ngroup[numgroups];
		while (c = *p++) {
			if (c == NGDELIM || c == ' ' || c == '\t')
				break;
			*q++ = c;
		}
		*q = 0;
		if (!invalid(ngroup[numgroups]))
			numgroups++;
		else {
			errs++;
			log("newsinput: invalid group %s ignored for: %s",
			    ngroup[numgroups], hp->ident);
		}
	}
	/* insert in junk notesfile only if we have no valid entries */
	if (errs && numgroups == 0) {
		strcpy(ngroup[0], JUNK);
		log("newsinput: no valid groups-junked: %s", hp->ident);
		numgroups = 1;
	}

	for (i = 0; i < numgroups; i++) {
		newsgroup(ngroup[i], nf);
		if ((strlen(hp->ctlmsg) != 0) ||
		    ((numgroups == 1) && tailmatch(ngroup[0],".ctl"))) {
			docontrol(hp);
#ifdef CTRLMSG
			strcpy(nf, CTRLMSG);
#else  CTRLMSG
			strcpy(nf, JUNK);
			log("newsinput: control message junked: %s", hp->ident);
#endif CTRLMSG
  		    	numgroups = 1;	/* only need one copy! */
		}
		num_groups++;

		if (hp->subtime < zaptime) {
		    /* If this article was submitted more than archtime days
		     * ago, move it to junk.
		     */
		    strcpy (nf, JUNK);
		    numgroups = 1;	/* only need one copy! */
		    if (verbose_mode)
		    	printf ("newsinput: zapped %s\n", hp->ident);
		}
		else if (verbose_mode)
		    printf ("newsinput: did not zap %s, sub:%ld >= zap:%ld\n",
		        hp->ident, hp->subtime, zaptime);

		/* well is it there? */
		ret = init(&io, nf);
#ifdef AUTOCREATE
		if (ret == QUITNEX) {
			/* try to create the notes file - RLS */
			sprintf(line, "%s/mknf", libdir);
			dosystem(line, "-on", nf, NOSTR);
			if ((ret = init(&io, nf)) < 0) {
				sprintf(line,
				    "%s%d\nnotesfile: %s, newsgroup %s\n",
				    "Autocreate failed, returncode ",
				    ret, nf, ngroup[i]);
				sprintf (line2, "autocreate failure: %s", nf);
				nfcomment(NOSUCHWARN, line, line2, 0, 0);
				log("newsinput: autocreate failed: %s", nf);
				continue;
			}
			sprintf(line2, "Created: %s", nf);
			sprintf(line,
"Non-existent notesfile %s has been autocreated by newsinput.\n\
Path: %s\n",
			    nf, hp->path);
			nfcomment(NOSUCHWARN, line, line2, 0, 0);
			log("created: %s", nf);
		}
#endif
		if (ret < 0) {
			sprintf(line,
			    "Newsinput failed: notesfile: %s, newsgroup %s\n",
			    ngroup[i], nf);
			sprintf(line2, "Failure: %s", nf);
			nfcomment(NOSUCHWARN, line, line2, 0, 0);
			log("%s: open failed: %s", hp->ident, nf);
			continue;
		}

		if (!archive &&		/* need to restore non-networked nf's*/
		    ((io.descr.d_stat & NETWRKD) == 0)) {
			/* not networked */
			log("%s: %s not networked", hp->ident, nf);
			finish(&io);
			continue;
		}

		if (insertart(&io, hp, rawnews) < 0) {
			finish(&io);
			continue;
		}

		lock(&io, 'n');
		getdscr(&io, &io.descr);
		io.descr.netwrkins++;		/* count as net in */
		putdscr(&io, &io.descr);
		unlock(&io, 'n');
		finish(&io);
	}
	fclose(rawnews);
}

/*
 * Notesfile specific processing
 */
insertart(io, hp, rawnews)
	struct io_f *io;
	struct hbuf *hp;
	FILE *rawnews;
{
	struct note_f note;
	struct note_f note2;
	struct number_f nfindex;
	int notenum;
	char psys[IDSZ], puniq[IDSZ];
	char firstref[IDSZ];

	parseid(hp->ident, puniq, psys);
	getperms(io, 1, psys);
	if (allow(io, WRITOK) == 0) {
		log("%s: %s: %s may not write notes", io->nf, hp->ident, psys);
		return(-1);
	}

	strcpy(note.n_title, hp->title);
	note.n_msg.m_stat = FRMNEWS;		/* came from news system */

	lock(io, 'n');
	notenum = chknote(io, hp->ident, &note2);
	if (notenum > 0) {
		if ((note2.n_msg.m_stat & ORPHND) == 0) {
			if (verbose_log)
			    log("%s: %s: duplicate note", io->nf, hp->ident); 
			io->nnotdrop++;
			unlock(io, 'n');
			return(-1);
		}
		/* replace foster parent */
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);   /* collect text */
		safecpy(note2.n_title,hp->title,TITLEN);
		note2.n_msg = note.n_msg;
		note2.n_lmod = hp->rectime;
		putnrec(io, notenum, &note2);	/* and replace */
		unlock(io, 'n');
#ifdef MSGID_INDEX
		putmsgid(io, notenum, 0, &note2.n_msg);
#endif /* MSGID_INDEX */		
		log("%s: %s: orphan replaced", io->nf, hp->ident);
		return(0);
	}

#ifdef notdef
#ifdef FULLREFS
	/* Reference line stuff */

	if (strlen(hp->followid) != 0) { /* Has References: line */
	    nfindex = chkref(io, hp->followid, &note2);
	    if (nfindex.note != -1) {  /* Reference found, insert response */
                if(chkresp(io, hp->ident, &note2, nfindex.note)) {
		    /* We already have a copy of this response */
                    unlock(io, 'n');
                    if (verbose_log)
                        log("%s: %s duplicate response", io->nf, hp->ident);
                    io->nrspdrop++;
		    return(-1);
		} else {
		    /* This response is new to us */
                    puthdr(io, &note.n_msg, hp);
                    pagein(io, rawnews, &note.n_msg.m_addr);
                    putresp(io, nfindex.note, &note2, &note.n_msg, ADDTIME);
                    unlock(io, 'n');
                    if (verbose_log)
                        log("%s: %s response inserted", io->nf, hp->ident);
                    io->nrsprcvd++;
                    return(0);
                }
	    } else {
		/* Referenced note does not exist.  Response is an Orphan. */
		struct hbuf hfake;

		/* Zero out header struct */
		bzero((char *)&hfake, sizeof hfake);
		
		/* Fill in the fields from the response */
		strcpy(hfake.ident, firstref);
		safecpy(note2.n_title, hp->title, TITLEN); /* Use same title */
		strcpy(hfake.nbuf, io->nf);
		sprintf(hfake.from, "Unknown");
		hfake.subtime = hp->subtime;
		hfake.rectime = hp->rectime;
		note2.n_msg.m_stat |= ORPHND;
		note2.n_nresp = 0;
		note2.n_msg.m_addr.addr = 0;

		puthdr(io, &note2.n_msg, &hfake);
		notenum = putnote(io, &note2, NOPOLICY, ADDTIME);

		/* bump count of recieved orphans */
		if (verbose_log)
		    log("%s: orphan %s created",
			hp->ident, firstref);
		io->norphans++;

		/* insert response */
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);
		putresp(io, notenum, &note2, &note.n_msg, ADDTIME);
		unlock(io, 'n');
		if (verbose_log)
		    log("%s: %s response inserted", io->nf, hp->ident);
		io->nrsprcvd++;
		return(0);
	    }
	}
#else /* FULLREFS */
	/*
	 * If we can match the first msg-ID in the "References:"
	 * field to a basenote, then tack it on as a response.
	 * Otherwise, insert it as an Orphan.
	 */

        /* We cut the line down to one Message-ID */
	safecpy(firstref, hp->followid, IDSZ);
	p = index(firstref, '>');
	if (p != NULL)
	    *++p = '\0';
	else
	    firstref[0] = '\0';		/* Malformed Message-ID.  Ignore. */
	
        if( strlen(firstref) != 0 ) {	/* Has "References:" field */
            notenum = chknote(io, firstref, &note2);
            fseek(rawnews, savepos, 0);
            if (notenum > 0) {		/* Referenced note exists */
                if(chkresp(io, hp->ident, &note2, notenum)) {
		    /* We already have a copy of this response */
                    unlock(io, 'n');
                    if (verbose_log)
                        log("%s: %s duplicate response", io->nf, hp->ident);
                    io->nrspdrop++;
		    return(-1);
		} else {
		    /* This response is new to us */
                    puthdr(io, &note.n_msg, hp);
                    pagein(io, rawnews, &note.n_msg.m_addr);
                    putresp(io, notenum, &note2, &note.n_msg, ADDTIME);
                    unlock(io, 'n');
                    if (verbose_log)
                        log("%s: %s response inserted", io->nf, hp->ident);
                    io->nrsprcvd++;
                    return(0);
                }
	    } else {
		/* Referenced note does not exist.  Response is an Orphan. */
		struct hbuf hfake;

		/* Zero out header struct */
		bzero((char *)&hfake, sizeof hfake);
		
		/* Fill in the fields from the response */
		strcpy(hfake.ident, firstref);
		safecpy(note2.n_title, hp->title, TITLEN); /* Use same title */
		strcpy(hfake.nbuf, io->nf);
		sprintf(hfake.from, "Unknown");
		hfake.subtime = hp->subtime;
		hfake.rectime = hp->rectime;
		note2.n_msg.m_stat |= ORPHND;
		note2.n_nresp = 0;
		note2.n_msg.m_addr.addr = 0;

		puthdr(io, &note2.n_msg, &hfake);
		notenum = putnote(io, &note2, NOPOLICY, ADDTIME);

		/* bump count of recieved orphans */
		if (verbose_log)
		    log("%s: orphan %s created",
			hp->ident, firstref);
		io->norphans++;

		/* insert response */
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);
		putresp(io, notenum, &note2, &note.n_msg, ADDTIME);
		unlock(io, 'n');
		if (verbose_log)
		    log("%s: %s response inserted", io->nf, hp->ident);
		io->nrsprcvd++;
		return(0);
	    }
      	}
#endif /* FULLREFS */
#endif /* notdef */	
	/*
	 * For notesfiles where we always post with the same title!
	 *	e.g., ai-list or news
	 */
	if (is_resp) {
		strcpy(io->xstring, title);
		notenum = findtitle(io, io->descr.d_nnote);
		if (notenum > 0)
			getnrec(io, notenum, &note2);
	}
	fseek(rawnews, savepos, 0);
	if (is_resp == 0 || notenum <= 0) {
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);
		notenum = putnote(io, &note, NOPOLICY, ADDTIME);
		/* count as networked in */
		if (verbose_log)
		    log("%s: %s note inserted", io->nf, hp->ident);
		io->nnotrcvd++;
	} else if (notenum > 0 && !chkresp(io, hp->ident, &note2, notenum)) {
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);
		putresp(io, notenum, &note2, &note.n_msg, ADDTIME);
		if (verbose_log)
		    log("%s: %s response inserted (title matched)", io->nf, hp->ident);
		io->nrsprcvd++;
	} else {
		if (verbose_log)
			log("%s: %s duplicate response", io->nf, hp->ident);
	}
	unlock(io, 'n');
	return(0);
}

/*
 * pull out relevant fields from the notes header
 * (currently only the status word)
 * if this is an old style note header (in the body of the text),
 * read past these lines.
 */
isnotes(hp, rawnews, has_suffix)
	struct hbuf *hp;
	FILE *rawnews;
        int has_suffix;
{
	int status;
	int found;
	int i;

	if (strlen(hp->nf_id) == 0) {
		/*
		 * No notes header in the B news article header...
		 * If title ends with "- nf", look for the
		 * header in the body of the text.
		 * (for backwards compatability)
		 */
		if (has_suffix == 0)
			return(0);
		found = 0;
		while (fgets(hp->nf_id, sizeof hp->nf_id, rawnews)) {
			if (hp->nf_id[0] == '#') {
				found++;
				break;
			}
		}
		if (!found ||
		    fgets(hp->nf_from, sizeof hp->nf_from, rawnews) == NULL)
			goto bad;
		savepos = ftell(rawnews);
	}

	if (hp->nf_id[0] != '#')
		goto bad;
	if (hp->nf_id[1] == 'N') {
		/* base note coming through news */
		i = sscanf(hp->nf_id, "#N:%*[^:]:%*ld:%o:%*d", &status);
		if (i == 4)
			return(status);
	} else if (hp->nf_id[1] == 'R') {
		/* response coming through news */
		i = sscanf(hp->nf_id,
		    "#R:%*[^:]:%*ld:%*[^:]:%*ld:%o:%*d", &status);
		if (i == 6)
			return(status);
	}
bad:
	return(0);
}

/*
 * A quick hack to check newsgroup name validity.
 * Eventually this needs to allow wildcards (either like the
 * subscribe/unsubscribe facility or the sys file in B news).
 */
invalid(name)
	char *name;
{
	FILE *f;
	char buf[CMDLEN];

	sprintf(buf, "%s/%s", libdir, INVALID);
	if ((f = fopen(buf, "r")) == NULL)
		return(0);
	while (fgets(buf, sizeof buf, f)) {
		buf[strlen(buf)-1] = '\0';
		if (match(buf, name) == 1) {
			fclose(f);
			return(1);
		}
	}
	fclose(f);
	return(0);
}

/*
 * get the generic notes title
 *
 *  returns 0 for no "Re:" and 1 if there was one.
 *  sets the second arg if there was a "- (nf)" suffix
 */
int
gettitle(s, has_suffix)
	char *s;
        int  *has_suffix;
{
	register char *p, *q;
	int has_re;

	/*
	 * see if a followup; strip all "Re:"'s
	 */
	has_re = 0;		/* Haven't seen a "Re:" yet */
	p = s;
	while ((p[0] == 'R' || p[0] == 'r') && (p[1] == 'e' || p[1] == 'E') &&
	    p[2] == ':') {
		p += 3;
		/* Skip Spaces */
		while (*p == ' ' || *p == '\t')
			p++;
		has_re = 1;
	}
	safecpy(title, p, TITLEN);
	/*
	 * Check for titles ending in "- nf".
	 * We always remove these.
	 */
	p = q = title;
	while (*p) {
		if (*p == '-')
			q = p;
		p++;
	}
	*has_suffix = 0;
	if (strcmp(q, NFSUFFIX) == 0 || strcmp(q, OLDSUFFIX) == 0) {
		if (--q > title)
			*q = '\0';	/* remove " - (nf)" suffix */
		(*has_suffix)++;
	}
	return has_re;
}


/*
 * setfromsys() -- try to glean the sending system from
 *    the "Path:" header line.
 */

static void setfromsys(pathline)
     char *pathline;
{
  char *p;
  char *q;

  for ( p = pathline ; isspace(*p) ; p++ )
    ;				/* strip leading whitespace */

  q = index(p, '!');
  if (q == 0) {			/* no bang in path; must be local */
      fromsys = strsave(hostname_in_path);
  }
  else {			/* have a bang in the path */
    *q = '\0';			/* terminate the sysname (temporarily) */

    if ( strlen(p) > 0 )
      fromsys = strsave(p);

    *q = '!';			/* put it back the way it was */
  }
}


static int tailmatch(string, tail)
     char *string;
     char *tail;
{
  char *pstring;
  char *ptail;

  if((string == NULL) || (tail == NULL))
    return 0;

  for(pstring=string ; *pstring != '\0' ; pstring++ )
    ;				/* Empty */
  for(ptail=tail     ; *ptail != '\0'   ; ptail++ )
    ;				/* Empty */

  while((*pstring == *ptail) &&
	(pstring != string) &&
	(ptail != tail))
    {
      pstring--; ptail--;
    }

  return ptail == tail;		/* Matched all characters in tail */
}

usage(s)
     char *s;
{
  printf("usage: %s [-A]\n", s);
  printf("\t-A\tfor reading in archives\n");
  printf("\t\tsets date received from Date:, and allows old articles\n");
}
