/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/newsfuncs.c,v 2.0 89/04/16 00:17:39 gore Exp $ */

/* Routines taken from B News 2.10.2 */

#include "parms.h"
#include "structs.h"
#include "header.h"

extern char *index();
extern char *rindex();

/*
 * Append NGDELIM to string.
 */
ngcat(s)
register char *s;
{
	if (*s) {
		while (*s++)
			;
		s -= 2;
		if (*s++ == NGDELIM)
			return;
	}
	*s++ = NGDELIM;
	*s = '\0';
}

/*
 * Delete trailing NGDELIM.
 */
ngdel(s)
register char *s;
{
	if (*s++) {
		while (*s++);
		s -= 2;
		if (*s == NGDELIM)
			*s = '\0';
	}
}

/*
 * Return a compact representation of the person who posted the given
 * message.  A sender or internet name will be used, otherwise
 * the last part of the path is used preceeded by an optional ".."
 */
char *
tailpath(hp)
struct hbuf *hp;
{
	char *p, *r;
	static char resultbuf[BUFLEN];
	char pathbuf[PATHLEN];
	char *malloc();

	/*
	 * This only happens for articles posted by old news software
	 * in non-internet format.
	 */
	resultbuf[0] = '\0';
	strcpy(pathbuf, hp->path);
	p = index(pathbuf, ' ');
	if (p)
		*p = '\0';	/* Chop off trailing " (name)" */
	r = rindex(pathbuf, '!');
	if (r == 0) {
		r = pathbuf;
	}
	else {
		while (r > pathbuf && *--r != '!')
			;
		if (r > pathbuf) {
			r++;
			strcpy(resultbuf, "..!");
		}
	}
	strcat(resultbuf, r);
	return resultbuf;
}
