/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/mstindex.c,v 2.0 89/04/16 00:16:32 gore Exp $ */

/*
 * INPUT KEY PROCESSING FOR INDEX PHASE 
 *
 *	Process all keystrokes while the index page is on the screen.
 *	invokes director options also (if user qualified)
 *	Returns: >=0 read note with that number ( 0 is policy)
 *		 -1	reprint the index page
 *		 -2	leave notefiles, update sequencer time
 *		 -3	leave notefile, dont update sequencer
 *		 -4	Universal leave notefiles
 *			(-2 and -3 leave single notefile, -4 leaves
 *			entire package, aborting rest of notefiles.
 */

#include "parms.h"
#include "structs.h"
#include <signal.h>
#include <sgtty.h>
#include <time.h>


mstindex(io, firstdis, lastdis, respnum)
	struct io_f *io;
	int *firstdis, *lastdis, *respnum;
{
	struct io_f io2;			/* for nested notefiles */
	char nfname[NNLEN];			/* for nested nfs */
	char sfile[WDLEN];
	char buf[BUFLEN];
	int num;				/* note number */
	int i;
	int c;
	int znote, zresp;			/* for asearch */
	int temp;
	int retstat = -1;
	struct notesenv oldenv;
	struct tm *tm;
	extern int terse;

	*respnum = 0;				/* init response */
	ignsigs = 0;
	replot = 1;
	oldenv = curenv;

	setjmp(jenv);
	while (1) {
		if (replot) {
			replot = 0;
			prntind(io, firstdis, lastdis);
		}
		cmdprompt();
		c = gchar(1);
		switch (c) {				/* what to do? */
		case 'z': 	/* update sequencer and exit */
			retstat = QUITUPD;
			goto out;

		case 'u':	/* unsubscribe from this notesgroup, RLS */
			prompt("Do you really want to unsubscribe from this notesfile? (y/n): ");
			if(askyn() != 'y') {
				at(0,1);	/* Bottom row */
				ceol();
				continue;	/* OK, don't unsubscribe */
			}
			at(0,1);
			ceol();
			prompt("(working)");
			fflush(stdout);
			if (unsubscribe(io->nf) < 0)
				continue;
			retstat = QUITSEQ;
			goto out;
			
		case 's': 			/* save files */
		case 'S':
			prompt("Note number: ");
			if (gline(buf, BUFLEN) == 0)
				continue;
			num = atoi(buf);
			prompt("File name: ");
			if (gline(sfile, WDLEN) == 0)
				continue;
			savefile(io, sfile, num, c == 'S' ? -1 : 0);
			continue;

		case '?': 
		case 'h': 
			nfhelp(INDXHLP);		/* put the help on screen */
			replot = 1;
			continue;

		case 'r': 			/* replot the index page */
		case '\014': 	/* everyone else uses ^L, might as well */
			replot = 1;
			continue;

		case 'W': 		/* this too shall write a note */
		case 'w': 		/* write a note */
			if (is_moderated(io))
			  {
			    int whoto, wtext;
			    struct note_f note;
			    
			    warn(
	     "This notesfile is moderated and may not be posted to directly.\n"
				 );
			    mailit(io, NULL, NULL, (int)MODERATOR, 0);
			    continue;
			  }

			/* OK, this is a normal notesfile */
			temp = addnote(io, (FILE *)0, "Edit Note text:",
			    "Note Title: ");
			if (temp == -1) {
				replot = 1;
				continue;
			}
			retstat = temp;
			goto out;

		case 'B': 			/* bitch, bitch, bitch */
			if (init(&io2, GRIPES) < 0) {	/* no gripe file */
				warn("Gripe file not available");
				continue;
			}
			/* let him put the note in */
		    	addnote(&io2, (FILE *)0, "Edit Gripe text:",
			    "Gripe Header: ");
			finish(&io2);		/* close up the gripe file */
			replot = 1;
			continue;

		case '-': 			       /* back up a little   */
		case '\b': 			       /* add backspace also */
			if (*firstdis != 1) {
				*firstdis -= nindex - 1;
				replot = 1;
			} else
				warn("On first page");
			continue;

		case '=': 				/* back up a lot */
			if (*firstdis != 1) {
				*firstdis = 1;
				replot = 1;
			} else
				warn("On first page");
			continue;

		case '+': 
		case '\n': 
		case ' ': 
			if (*lastdis < io->descr.d_nnote) {
				*firstdis = *lastdis;
				replot = 1;
			} else
				warn("On last page");
			continue;

		case '*': 			/* skip to last page */
			if (*lastdis < io->descr.d_nnote) {
				*firstdis = io->descr.d_nnote - nindex + 1;
				replot = 1;
			} else
				warn("Already on last page");
			continue;

		case 'q': 
		case 'k': 			/* so can use just right hand */
			retstat = QUITSEQ;
			goto out;

		case '\04': 				/* control D */
			retstat = QUITFAST;
			goto out;

		case 'Q': 		/* exit without update of sequencer */
		case 'K': 		/* so can use just right hand */
			retstat = QUITNOSEQ;
			goto out;

		case 'n': 			/* nest notesfiles - a stack */
			prompt("New notesfile: ");
			if (gline(nfname, NNLEN) == 0)
				continue;
			closenf(io);				/* save fids */
			i = control(nfname, NOSEQ | terse?TERSE:0, (time_t)0);
			if (opennf(io, io->nf) < 0) {
				warn("Couldn't reopen notesfile");
				wfchar();
				retstat = QUITNOSEQ;
				goto out;
			}
			if (i == QUITNEX || i == QUITBAD) {
				warn("Can not open notesfile `%s'", nfname);
				continue;
			}
			if (i == QUITFAST || i == QUITUPD) {
				retstat = i;
				goto out;
			}
			replot = 1;
			continue;

		case 'p': 				/* to read note 0 */
			if (io->descr.d_plcy) {
				retstat = 0;
				goto out;
			} else {
				warn("There is no policy note");
				continue;		/* grab another key */
			}

		case 'd': 			/* to director options */
			if (allow(io, DRCTOK)) {
				if ((i = direct(io)) == -1) {
					replot = 1;
					continue;
				}
				retstat = i;
				goto out;
			} 
			/*
			 * fix the allow the user to see things
			 * the director can see
			 */
			prompt("Anonymous: %s 	  Networked: %s",
			(io->descr.d_stat & ANONOK) ? "YES" : "NO",
			(io->descr.d_stat & NETWRKD) ? "YES" : "NO");
			continue;

		case 'x': 
		case 'X': 
			i = tsearch(io, *lastdis+1, c == 'x');
			/* assume lies before here */
			if (i > 0) {
				retstat = i;
				goto out;
			}
			continue;		/* otherwise get another key */

		case 'a': 
		case 'A': 		/* author search from current spot */
			znote = *lastdis + 1;
			zresp = 0;		/* start at the correct place */
			i = asearch(io, &znote, &zresp, (c == 'a'));
			/* look */
			if (i > 0) {
				*respnum = zresp;/* return correct value */
				retstat = znote;
				goto out;
			}
			continue;		/* get another command */

		case '1': 
		case '2': 
		case '3': 
		case '4': 
		case '5': 
		case '6': 
		case '7': 
		case '8': 
		case '9': 
			prompt("Read note > ");
			if ((num = getnum (c)) == 0)
				continue;
			retstat = num;
			goto out;

		case 'j': 
		case 'J':			/* goto first unread article */
		case 'l':			/* universal seq, RLS */
		case 'L':
			i = nxtnote(io, 0, io->stime);
			if (i != -1) {
				*respnum = nxtmsg(io, i, -1, io->stime);
				retstat = i;
				goto out;
			}
			if (c == 'l' || c == 'L') {
				retstat = QUITSEQ;
				goto out;
			}
			replot = 1;
			continue;

		case 'o':			/* modify sequencer time */
			while (1) {
				time_t t;

				at(-1, 1);
				putstr("Set to read notes since: ");
				prdate(io->stime);
				clear_eol();
				prompt("Enter new sequencer time: ", buf);
				if (gline(buf, BUFLEN) > 0) {
					t = getdate(buf, (struct timeb *)0);
					if (t < 0) {
						warn("bad date format");
						continue;
					}
					io->stime = t;
				}
				else {
					at(-1, 1);
					clear_eol();
					at(0, 1);
					clear_eol();
					break;
				}
			}
			continue;			/* and go back */

		case 'O': 			/* set it for today's notes */
			time(&io->stime);		/* grab current date */
			tm = localtime(&io->stime);
			tm->tm_hour = tm->tm_min = tm->tm_sec = 0;
			tm_to_time(tm, &io->stime);
			prompt("Set to read notes since: ");
			prdate(io->stime);
			continue;		/* and get the next command */

		case '!': 
			gshell();
			/* give him a shell in right directory */
			replot = 1;
			continue;

		case 't':			/* toggle terse mode */
			terse = !terse;
			prompt("%s mode", terse ? "terse" : "verbose");
			replot = 1;
			break;

		default: 
			warn("? for help, q to quit");
			continue;
		}
	}
	/*NOT REACHED*/
out:
	ignsigs++;
	curenv = oldenv;
	ignsigs = 0;
	return(retstat);
}
