#ifndef __STRING_POOL__
#define __STRING_POOL__

#ifndef __STRUCTS__
#  include "structs.h"	/* for io_f */
#endif  __STRUCTS__

/*
 * These are used to identify strings within the string pool.
 * Adding new ones should be quite safe, but think twice before
 * changing the meaning of an old number.
 */
#define SP_SUBMISN_ADDR	0

/*
 * The number of bytes allocated to each string in the string pool file.
 * If you change this, you will need to write a program to convert the
 * string pools in your database!
 */
#define SP_STR_LEN	256

typedef struct {
    int fd;
    struct io_f *io;
} sp_t;

#define SP_OPEN_ERR -1

#ifdef __STDC__

extern sp_t	sp_open(struct io_f*);
extern int	sp_close(sp_t);
extern void	sp_get_string(sp_t, char*, int, int);
extern void	sp_put_string(sp_t, char*, int);

#else /*!__STDC__*/

extern sp_t	sp_open();
extern int	sp_close();
extern void	sp_get_string();
extern void	sp_put_string();

#endif /*!__STDC__*/

#endif __STRING_POOL__
