/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/savefile.c,v 2.0 89/04/16 01:10:36 gore Exp $ */

#include "parms.h"
#include "structs.h"
#include "dumpmsg.h"

/*
 * save a note or response in a file
 * set up the filename, save the message(s),
 * and report lines saved
 */
savefile(io, file, note, resp)
	struct io_f *io;
	char *file;
	int note, resp;
{
	int ret;
	int i, lines;
	int notesmask;
	FILE *f, *rfopen();
	char *filexp();

	notesmask = umask(msk);		/* Restore users umask */
	file = filexp(file);
	if ((f = rfopen(file, &ret)) == NULL) {
	    warn("%s: cannot create file", file);
	    umask(notesmask); 	/* Back to normal */
	    return;
	}
	ignsigs++;
	prompt("Saving...");
	fflush(stdout);
	lines = 0;
	if (ret >= 0) {
	    /* if appending, make sure a \n separates articles */
	    putc('\n', f);
	    lines++;
	}
	/* SHOULD CHANGE TO LIST OF NOTES */
	{
	    i = saveit(io, f, note, resp);
	    if (i < 0)
	      goto out;
	    lines += i;
	}
	prompt("\"%s\" [%s] %d lines", file,
	       ret < 0 ? "New file" : "Appended", lines);
out:
	fclose(f);
	ignsigs--;
	umask(notesmask); 	/* Back to normal */
}

/*
 * do the hard work of saving a file
 */
saveit(io, f, note, resp)
	struct io_f *io;
	FILE *f;
	int note, resp;
{
	int i, lines;
	struct note_f noterec;
	struct resp_f rsprec;
	int rrecnum, roffset;

	if (note <= 0 || note > io->descr.d_nnote) {
		warn("Note number %d out of range", note);
		return(-1);
	}
	getnrec(io, note, &noterec);
	if (resp > 0 && (resp > noterec.n_nresp ||
	    lrsp(io, note, resp, &rsprec, &roffset, &rrecnum) == -1)) {
		warn("Response number out of range");
		return(-1);
	}
	if (resp < 0) {
		/* save whole string */
		lines = dumpmsg(io, &noterec, &noterec.n_msg, 0,
				dmp_format, f);
		for (i = 1; i <= noterec.n_nresp; i++) {
			if (lrsp(io, note, i, &rsprec, &roffset,
			    &rrecnum) == -1)
				continue;
			putc('\n', f); lines++;
			lines += dumpmsg(io, &noterec, &rsprec.r_msg[roffset],
			    1, dmp_format, f);
		}
	} else if (resp == 0)
		lines = dumpmsg(io, &noterec, &noterec.n_msg, 0,
				dmp_format, f);
	else
		lines = dumpmsg(io, &noterec, &rsprec.r_msg[roffset], 1,
				dmp_format, f);
	return(lines);
}
