/* $Header: readrc.c,v 1.2 86/06/17 15:46:35 notes Exp $ */

/*
 * Routines to manage a .notesrc file
 */

#include <signal.h>
#include "parms.h"
#include "structs.h"

char *notesrc;

/*
 * read a file which contains the command line arguments
 */
readrc(s)
char *s;
{
	FILE *f;
	char buf[BUFSIZ];

	if ((f = fopen(s, "r")) == NULL)
		return(-1);
	while (fgets(buf, sizeof buf -1, f))
		expand(buf);
	fclose(f);
	return(0);
}

/*
 * unsubscribe to a notesfile
 */
unsubscribe(name)
char *name;
{
	FILE *fp, *rfopen();
	int ret;

	if (notesrc == 0) {
		warn("No notesrc file");
		return(-1);
	}
	if ((fp = rfopen(notesrc, &ret)) == NULL) {
		warn("Can not open %s", notesrc);
		return(-1);
	}
	/*
	 * append the notesgroup name to the
	 * end of the notesrc file
	 */
	ignsigs++;
	fprintf(fp, "!%s\n", name);  /* append a not */
	fclose(fp);
	ignsigs--;
	return(0);
}
