/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/puthdr.c,v 2.0 89/04/16 01:07:14 gore Exp $ */

#include "parms.h"
#include "structs.h"
#include "header.h"

/*
 * take a header for a message and
 * insert into the notes system
 */
puthdr(io, msgp, hp)
	struct io_f *io;
	struct msg_f *msgp;
	struct hbuf *hp;
{
	int i;

	/* update times */
	msgp->m_rcvtime = hp->rectime;
	msgp->m_subtime = hp->subtime;

	/* write the header lines */
	t_stext(io, &msgp->m_head);

	/* author */
	fputs(hp->from, io->fidtxt);  putc(0, io->fidtxt);
	msgp->m_from = 0;
	i = strlen(hp->from) + 1;

	/* article id */
	fputs(hp->ident, io->fidtxt);  putc(0, io->fidtxt);
	msgp->m_artid = i;
	i += strlen(hp->ident) + 1;

	/* path */
	fputs(hp->path, io->fidtxt);  putc(0, io->fidtxt);
	msgp->m_path = i;
	i += strlen(hp->path) + 1;
	
	/* organization */
	fputs(hp->organization, io->fidtxt); putc(0, io->fidtxt);
	msgp->m_org = i;
	i += strlen(hp->organization) + 1;

	/* reply-to */
	fputs(hp->replyto, io->fidtxt);  putc(0, io->fidtxt);
	msgp->m_replyto = i;
	i += strlen(hp->replyto) + 1;
	
	/* notesfile */
	fputs(hp->nbuf, io->fidtxt);  putc(0, io->fidtxt);
	msgp->m_ngroup = i;
	i += strlen(hp->nbuf) + 1;

#ifdef CONTROL
	/* control */
	fputs(hp->ctlmsg, io->fidtxt);  putc(0, io->fidtxt);
	msgp->m_ctlmsg = i;
	i += strlen(hp->ctlmsg) + 1;
#endif
	/* spares */
	/*
	 * Point all spares at a nullstring.  Later, we might want to 
	 * use one of these without rebuilding the entire database.
	 */
	putc(0, io->fidtxt);
#ifndef CONTROL
	msgp->m_ctlmsg = i;
#endif
	msgp->m_spare1 = i;
	msgp->m_spare2 = i;
	i++;

	/* miscellaneous */
	msgp->m_misc = i;

	/* relay version intentionally not stored */
	if (hp->postversion[0])
		fprintf(io->fidtxt, "Posting-Version: %s\n", hp->postversion);
	if (hp->followid[0])
		fprintf(io->fidtxt, "References: %s\n", hp->followid);
	if (hp->distribution[0])
		fprintf(io->fidtxt, "Distribution: %s\n", hp->distribution);
	if (hp->sender[0])
		fprintf(io->fidtxt, "Sender: %s\n", hp->sender);
	if (hp->replyto[0])
		fprintf(io->fidtxt, "Reply-To: %s\n", hp->replyto);
	/* recdate intentionally not stored */
	if (hp->expdate[0])
		fprintf(io->fidtxt, "Expires: %s\n", hp->expdate);
	if (hp->followto[0])
		fprintf(io->fidtxt, "Followup-to: %s\n", hp->followto);
	if (hp->keywords[0])
		fprintf(io->fidtxt, "Keywords: %s\n", hp->keywords);
	if (hp->approved[0])
		fprintf(io->fidtxt, "Approved: %s\n", hp->approved);
	if (hp->numlines[0])
		fprintf(io->fidtxt, "Lines: %s\n", hp->numlines);
	if (hp->nf_id[0])
		fprintf(io->fidtxt, "Nf-ID: %s\n", hp->nf_id);
	if (hp->nf_from[0])
		fprintf(io->fidtxt, "Nf-From: %s\n", hp->nf_from);
	for (i = 0; i < NUNREC; i++) {
		if (hp->unrec[i] == 0)
			break;
		fputs(hp->unrec[i], io->fidtxt);
	}

	t_etext(io, &msgp->m_head);
}

