/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/next.c,v 2.0 89/04/16 00:57:30 gore Exp $ */

/*
 *	next.c -	find the next note/response after a certain time
 *
 *	nxtnote(io,note,date)
 *		finds the next note with number > note which has been 
 *	modified after date. If none exists, a -1 is returned, otherwise
 *	the note number is returned.
 *	   This is used to find the next notes string to look at.  Always
 *	call nxtmsg() to find the right message in the string.
 *
 *	nxtresp(io,note,resp,date)
 *		same idea as above, except, we look through the responses 
 *	after resp to note # note. If there is no response, we return 
 *	a -1, else we return the response number.
 *	   Messages are checked to make sure that we haven't seen a
 *	cross-posted version of them before.
 *
 *	Original coding:	Ray Essick	november 1981
 */

#include "parms.h"
#include "structs.h"
#include <sys/stat.h>

nxtnote(io, note, date)
struct io_f *io;
time_t date;
{
	struct note_f   znote;

	if (note < 0)
		note = 0;			/* start at beginning */
	note++;				/* find starts with next note ! */
	while (note <= io->descr.d_nnote) {
		getnrec(io, note, &znote);	/* get note header */
		if (znote.n_stat & DELETED) {
			note++;			/* go on to the next note */
			continue;		/* try the next note */
		}
		if (znote.n_lmod >= date	/* want equals to show */
		    && !seen_crosspost(io, &znote.n_msg, znote.n_lmod)) {
			return(note);		/* modified after date */
		}
		note++;				/* go try the next note */
	}
	return(-1);				/* wasn't a more recent note */
}

nxtmsg(io, note, resp, date)
struct io_f *io;
time_t date;
{
	struct note_f znote;
	struct resp_f rrec;
	int poffset, recnum;

	getnrec(io, note, &znote);
	if (resp < 0) {
		if (znote.n_msg.m_rcvtime >= date &&
		    !seen_crosspost(io, &znote.n_msg, znote.n_msg.m_rcvtime))
			return(0);
		resp = 0;		/* can't look at negative response */
	}
	resp++;				/* start search at next response */
	while (resp <= znote.n_nresp) {
		if (lrsp(io, note, resp, &rrec, &poffset, &recnum) == -1)
			break;		/* no response, drop out */
		if (rrec.r_msg[poffset].m_rcvtime >= date 
		    && !seen_crosspost(io, &rrec.r_msg[poffset],
				       rrec.r_msg[poffset].m_rcvtime))
			return(resp);	/* return if date earlier or same */
		resp++;
	}
	return(-1);			/* no later responses to this note */
}

nfmod_before(p, t)
	char *p;
	time_t t;
{
	struct stat sb;
	char fn[WDLEN];

	sprintf(fn, "%s/%s/%s", spooldir, mapnfname(p), TEXT);
	if (stat(fn, &sb) < 0)
		return(0);
	return(sb.st_mtime < t);
}


/*
  Check to see if a crossposted article has been seen before.
  We check the sequencer date for each newsgroup it was posted
  to.  If the sequencer time for any group is later than the
  date received, assume we've seen it.
*/

seen_crosspost(iop, msgp, date)
     struct io_f  *iop;
     struct msg_f *msgp;
     time_t date;
{
  struct nfile *np;
  char ng_buf[1024];		/* holds Newsgroups: header line */
  char *cur_ng;

  if (!jump_over_xposts) return 0;

  gethdr(iop, msgp, msgp->m_ngroup, ng_buf);

  for (cur_ng = strtok(ng_buf, " \t\n,") ; cur_ng != NULL ;
       cur_ng = strtok(NULL,   " \t\n,"))
    {
      if (strcmp(iop->nf, cur_ng) == 0) continue;
      if ((np=getnfile(cur_ng)) != 0)
	if (np->n_when > date)
	  return 1;		/* We've seen this one */
	else
	  continue;
    }
  return 0;			/* Haven't seen it yet */
}

