/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/arpadate.c,v 2.0 89/04/16 00:42:31 gore Exp $ */

#include "parms.h"
#include "structs.h"
#include <time.h>

extern char *mnames[];
extern char *daynames[];	/* In rfc822.c */

#ifndef	SYSV
extern char *timezone();
#endif	SYSV

/*
 * prints local date and time in ARPA format.  Same as arpadate(), but
 * for local timezone.
 */
char *
localdate(longtime)
time_t *longtime;
{
	struct tm *tm;
	static char b[40];

#ifdef	SYSV
	tzset();
#endif	SYSV	
	tm = localtime(longtime);
	sprintf(b, "%s, %d %3s %02d %02d:%02d:%02d %3s",
	    daynames[tm->tm_wday], tm->tm_mday, mnames[tm->tm_mon],
	    tm->tm_year, tm->tm_hour, tm->tm_min, tm->tm_sec,
#ifdef	SYSV
	    tzname[tm->tm_isdst ? 1 : 0]);
#else	!SYSV
	    timezone(tzone(), tm->tm_isdst));
#endif	SYSV
	return(b);
}
