#include <stdio.h>

#define STDIN 0
#define STDOUT 1
#define NL '\n'
#define BUFFER_SIZE 4096      /* sure to get a newline before that */

char buf[BUFFER_SIZE];

main () {
    register char *cp;
    register int num_bytes, num_left;

    if ((num_bytes = read(STDIN, buf, BUFFER_SIZE)) < 0) {
	perror("read"); 
	exit(num_bytes);
    }

    if (num_bytes == 0) {
	fprintf(stderr, "premature end of input\n");
	exit(-1);
    }

    for (cp = buf; cp < buf + num_bytes; cp++) {
	if (*cp == NL) break;
    }

    ++cp;
    num_left = buf + num_bytes - cp;

    if (num_left < 0) {
	fprintf(stderr, "no new line character in first %d bytes of input\n",
		num_bytes);
	exit(-1);
    }

    /* found it; output rest of buffer and rest of file */

    if (num_left > 0) {
    	write(STDOUT, cp, num_left);
    }


    /* now for the rest of the file */
    while ((num_bytes = read(STDIN, buf, BUFFER_SIZE)) > 0) {
	write(STDOUT, buf, num_bytes);
    }
    if (num_bytes != 0) {
	perror("read");
	exit(-1);
    }

}
