#define	PERMUSER	0	/* for perm_f - entry type */
#define	PERMGROUP	1	/* ORDER IS IMPORTANT */
#define	PERMSYSTEM	2

#define	PERMDELETED 10000	/* This is added to PERMwhatever
				 * to mark an entry as deleted.
				 * Must fit in sizeof(ptype)!
				 */

struct perm_f {				/* permission tables */
	short	ptype;			/* user, group, system */
	char	name[NAMESZ];		/* name of such */
	short	perms;			/* what he is allowed */
};

/* Access control entry */
typedef struct perm_f ace_t;

/* Access control list */
typedef struct {
    char filename[WDLEN];
    ace_t items[NPERMS];
    int length, num_deleted;
    int changed;
} acl_t;

/* Handle into the list */
typedef int acl_h;

#ifdef __STDC__

extern acl_t*	acl_open(struct io_f*);
extern acl_t*	acl_create(struct io_f*);
extern acl_t*	acl_create_quick(char*);
extern int	acl_close(acl_t*);
extern acl_h	acl_first(acl_t*);
extern acl_h	acl_nth(acl_t*, int);
extern acl_h	acl_next(acl_t*, acl_h);
extern acl_h	acl_find(acl_t*, ace_t*);
extern ace_t*	acl_ace(acl_t*, acl_h);
extern acl_h	acl_replace(acl_t*, acl_h, ace_t*);
extern acl_h	acl_add(acl_t*, ace_t*);
extern int	acl_delete(acl_t*, acl_h);
extern int	acl_delete_ace(acl_t*, ace_t*);
extern int	acl_sort(acl_t*);
extern int	acl_was_changed(acl_t*);
extern int	ace_compare(ace_t*, ace_t*);
extern int	ace_same(ace_t*, ace_t*);
extern int	ace_copy(ace_t*, ace_t*);

#else /* not ANSI C */

extern acl_t*	acl_open();
extern acl_t*	acl_create();
extern acl_t*	acl_create_quick();
extern int	acl_close();
extern acl_h	acl_first();
extern acl_h	acl_nth();
extern acl_h	acl_next();
extern acl_h	acl_find();
extern ace_t*	acl_ace();
extern acl_h	acl_replace();
extern acl_h	acl_add();
extern int	acl_delete();
extern int	acl_delete_ace();
extern int	acl_sort();
extern int	acl_was_changed();
extern int	ace_compare();
extern int	ace_same();
extern int	ace_copy();

#endif __STDC__

#define ACL_NOHANDLE (-1)
