

/*
 * Routines and externals for access by the user program
 */
 /*
  * Newsclip(TM) Library Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip library for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed.
  * Use of this code for a short term evaluation of the product, as defined
  * in the associated file, 'Licence', is permitted.
  */


#include "nl.h"
#include <ctype.h>

/* externals */

char *article_filename;			/* the filename of the article, if
						available */

int score;				/* the score the article got */

int white_compress = FALSE;		/* compress white space */
int paragraph_scan = FALSE;		/* scan text as paragraphs */
int preserve_case = FALSE;		/* don't lower case text */

char *signature_start = "^-- *$";	/* start of signature */

char *include_prefix = "^[ \t]*[:>#%]";	/* included text */


char *
arr_string( thear, type, dex )
array *thear;
dtype type;		/* array type */
int dex;		/* dex into array */
{

	switch( type ) {
		case T_NEWSGROUP:
			return ngn(thear->vals[dex].uinteger);
		case T_USERNAME:
			return thear->vals[dex].uusername->emailname;
		case T_STRING:
			return thear->vals[dex].ustring;
		default:
			return "foo";
		}
}

/*
 * Now we have the various "in" routines which implement the in
 * operator.  There is acutally a wide cross product of such routines,
 * based on the fact that you can search for a variety of types in
 * a variety of types.  Scalars and arrays can be searched for in arrays
 * and databases, and the various semi-compatible string-like types
 * are mostly dealt with
 */


arr_in_db( arr, db )
array *arr;			/* array of string like objects */
dbptr db;			/* database to look in */
{
	register int i;
	char *str;

	if( !arr )
		return FALSE;

	for( i = 0; i < arr->arsize; i++ ) {
		if( str_in_db( arr_string(arr,arr->artype,i), db ) )
			return TRUE;
		}
	return FALSE;
}

str_in_db( str, db )
char *str;			/* string to check for */
dbptr db;			/* database to look in */
{
	register userdb *rec;
	extern long time_now;

	if( rec = (userdb*)get_rec( db, str ) ) {
		rec->access_date = time_now;
		return TRUE;
		}
	 else
		return FALSE;
}

arr_in_arr( ar1, ar2 )
array *ar1;			/* values to look for */
array *ar2;			/* array to look in */
{
	/* we can search for ngs, usernames and strings in strings */
	int i1, i2;			/* index vars */
	dtype ty1, ty2;

	if( !ar1 || !ar2 )
		return FALSE;

	ty1 = ar1->artype;
	ty2 = ar2->artype;

	if( ty1 == ty2 ) {
		for( i1 = 0; i1 < ar1->arsize; i1++ )
			for( i2 = 0; i2 < ar2->arsize; i2++ )
				switch( ty1 ) {
					case T_INTEGER:
					case T_NEWSGROUP:
						if( ar1->vals[i1].uinteger ==
							ar2->vals[i2].uinteger)
							return TRUE;
						break;
					case T_DATE:
						if( ar1->vals[i1].udate ==
							ar2->vals[i2].udate)
							return TRUE;
						break;
					case T_STRING:
						if(strcmp(ar1->vals[i1].ustring,
							ar2->vals[i2].ustring)
								== 0 )
							return TRUE;
						break;
					case T_USERNAME:
						if(strcmp(ar1->vals[i1].uusername->emailname,
							ar2->vals[i2].uusername->emailname)
								== 0 )
							return TRUE;
						break;
						}
		}
	 else {
		for( i1 = 0; i1 < ar1->arsize; i1++ )
			for( i2 = 0; i2 < ar2->arsize; i2++ )
				if( strcmp(arr_string(ar1,ty1,i1),
						arr_string(ar2,ty2,i2)) == 0 )
					return TRUE;
		}
	return FALSE;
}

int_in_arr( val, arr )
int val;			/* value to search for */
array *arr;			/* array to search in */
{
	int i;
	if( !arr )
		return FALSE;
	for( i = 0; i < arr->arsize; i++ )
		if( val == arr->vals[i].uinteger )
			return TRUE;
	return FALSE;
}


date_in_arr( val, arr )
datehold val;			/* value to search for */
array *arr;			/* array to search in */
{
	int i;
	if( !arr )
		return FALSE;
	for( i = 0; i < arr->arsize; i++ )
		if( val == arr->vals[i].udate )
			return TRUE;
	return FALSE;
}

ng_in_arr( val, arr )
newsgroup val;			/* value to search for */
array *arr;			/* array to search in */
{
	int i;
	dtype ty;
	if( !arr )
		return FALSE;

	ty = arr->artype;
	if( ty == T_NEWSGROUP ) {
		for( i = 0; i < arr->arsize; i++ )
			if( val == arr->vals[i].uinteger )
				return TRUE;
		}
	 else {
		char *ngname;
		ngname = ngn(val);
		for( i = 0; i < arr->arsize; i++ )
			if( cleq( ngname, arr_string(arr,ty,i) ) )
				return TRUE;
		}
	return FALSE;
}

str_in_arr( val, arr )
char * val;			/* value to search for */
array *arr;			/* array to search in */
{
	int i;
	dtype ty;
	if( !arr )
		return FALSE;

	ty = arr->artype;
	for( i = 0; i < arr->arsize; i++ )
		if( strcmp( val, arr_string(arr,ty,i) ) == 0 )
			return TRUE;
	return FALSE;
}

name_in_arr( val, arr )
username *val;			/* value to search for */
array *arr;			/* array to search in */
{
	int i;
	char *mailn;		/* mail name */
	dtype ty;
	if( !arr )
		return FALSE;

	ty = arr->artype;

	mailn = val->emailname;
	for( i = 0; i < arr->arsize; i++ )
		if( cleq( mailn, arr_string(arr,ty,i)) )
			return TRUE;
	return FALSE;
}

/* Functions to parse strings with dots */

/* Return the leftmost part of the string, bound by 'num' dots */

char *
left( str, num )
char *str;		/* string to parse */
int num;		/* how many sections to return */
{
	int i;
	char *p;	/* scan through for dots */
	char *ret;

	p = str;

	for( i = 0; i < num; i++ ) {
		p = strchr( p, '.' );
		if( p )
			p++;
		 else
			break;
		}
	if( p && p > str) {
		int len;
		len = (p - str) - 1;
		ret = temp_alloc( len + 1 );
		strncpy( ret, str, len );
		ret[len] = 0;
		return ret;
		}
	 else
		return num > 0 ? str : "";
}

/* return the rightmost substring based on dots */

char *
right( str, num )
char *str;
int num;
{
	int i;
	if( num < 0 )
		return "";

	for( i = strlen(str)-1; i >= 0; i-- )
		if( str[i] == '.' )
			if( --num <= 0 )
				return str + i + 1;
	return str;
}

/* return the domain from a mail address */

char *
domain( str )
char *str;
{
	char *at;
	if( at = strchr( str, '@' ) )
		return at+1;
	 else
		return str;
}

/* distribution level for a newsgroup */

int
dlevel( ng )
newsgroup ng;
{
	return ngarray[ng]->distribution;
}

/* check for the presence of a newsgroup.  This is generated by the
 * 'is' operator 
 */

gquery( n )
register newsgroup n;
{
	extern array *newsgroups;
	register int i;
	int ncount;

	ncount = newsgroups->arsize;
	for( i = 0; i < ncount; i++ )
		if( newsgroups->vals[i].uinteger == n )
			return TRUE;
	return FALSE;
}

/* Concatenate two strings together and leave the result in new
   temporary memory */

char *
concat( s1, s2 )
char *s1;
char *s2;
{
	unsigned int len, l1;
	char *ret;

	l1 = strlen(s1);
	len = l1 + strlen(s2);
	ret = temp_alloc( len+1 );
	strcpy( ret, s1 );
	strcpy( ret+l1, s2 );
	return ret;
}

/* Remove any level of "Re: " from the front of a string, most probably
 * a subject line
 */


char *
drop_re( str )
char *str;
{
	register char *p;

	for( p = str; *p; p++ ) {
		if( *p == ' ' )
			continue;
		 else if( lowerlet(p[0]) == 'r' && lowerlet(p[1]) == 'e' &&
				p[2] == ':' )
			p +=2;
		 else
			break;
		}
	return p;
}

char *
lower( str )
char *str;
{
	char *ret;
	ret = temp_string( str );
	lowercase( ret );
	return ret;
}

int
named_group( n )
newsgroup n;
{
	extern int user_gcount;
	return n > 0 && n <= user_gcount;
}

/* is the group in the .newsrc */
int
newsrc_group( n )
newsgroup n;
{
	return !!(ngarray[n]->gflag & GF_RCGROUP);
}

/* string compare */

str_eq( a, b )
char *a, *b;		/* two strings to compare */
{
	if( a == b )
		return TRUE;
	if( !a || !b )
		return FALSE;		/* one is nil string */
	return strcmp( a, b ) == 0;
}

/* the string, missing N chars from the front */

char *
clipfront( str, num )
char *str;
int num;
{
	int len;
	len = strlen(str);
	if( num < len )
		return str + num;
	 else
		return "";
}

/* The leftmost N chars of a string */
char *
leftmost( str, num )
char *str;
int num;
{
	int len;
	char *ret;

	len = strlen(str);
	if( num >= len )
		return str;
	 else {
		ret = temp_alloc( num + 1 );
		strncpy( ret, str, num );
		ret[num] = 0;
		return ret;
		}
}
