/*
 * rei.h
 *
 * Regular expression handler interface.  Unfortunately, more than simply 
 * altering these definitions may be required to substitute an alternate
 * regular expression compilation/execution package, mostly due to the
 * notions of how memory allocation is handled.  Of course, the RE syntax
 * itself may vary as well.
 *
 */

/* Interface to Henry Spencer's [slightly modified] regexp(3) package.  */

#include "rxp.h"

#define	REG_COMP_T(exp)    regcomp(exp,RXP_MEM_TEMP) /* Compile a temp. RE */
#define	REG_COMP_P(exp)    regcomp(exp,RXP_MEM_PERM) /* Compile a perm. RE */
#define REG_COMP_S(exp)	   regcomp(exp,RXP_MEM_STAT) /* Compile a static RE */
#define	REG_EXEC(prog,str) regexec(prog,str)	     /* Execute an RE */
#define REG_FREE_T(prog)   			     /* Free a temp. RE */
#define REG_FREE_P(prog)   perm_free(prog)	     /* Free a perm. RE */
#define REG_FREE_S(prog)			     /* Free a static RE */

typedef regexp *rxp_type;	/* Type handle for compiled REs */
