

/* Definitions for News Filter pipe mode */

/* Unlike the other files in the NewsClip distribution, this file and
 * 'filtpipe.c' are released to the public domain.
 */


#define AS_SIZE 3
#define SEQ_SIZE 6			/* adjust to make struct even bound */
#ifdef MAX_LLEN
# define MAX_ARGLEN MAX_LLEN
#else
# define MAX_ARGLEN 255
#endif

#define TRUE 1
#define FALSE 0

	/* struct for start of message */

struct command {
	char comtype;			/* message type, usually 'C' */
	char comcode;			/* command code */
	char space;			/* the delimiting space */
	char seq_num[SEQ_SIZE];		/* sequence number plus 0 */
	char space2;			/* extra space */
	char arg_size[AS_SIZE];		/* argument size */
	char zerob;			/* a zero byte */
	};

#define MAX_ARGS 40			/* max arguments to a command */

#define ABASE 1				/* first real argument */

/* The pipes we use to talk to the reader (filter end)*/

#define F_COMPIPE 0		/* stdin */
#define F_ANSPIPE 1		/* stdout */

#ifndef NULL
#define NULL (char *)0
#endif
