/*
 * db.h
 *
 * Interface definitions for the database manager.
 * Copyright (c) 1989 Looking Glass Software Limited.
 *
 */

typedef struct _dbr {
	char *key;			/* Ptr to the storage key.	    */
	struct _dbr *next;		/* Ptr to next hash bucket.	    */
	unsigned char flags;		/* Flags -- facts about the bucket. */
	} dbrec;

typedef struct {
	unsigned int tbl_size;		/* Table size of the database.	    */
	unsigned int item_size;		/* Size of data items in database.  */
	unsigned long n_elements;	/* Number of elements in database.  */
	unsigned char flags;		/* Flags with info about database.  */
	dbrec **table;			/* Table of ptrs to hash chains.    */
	} db_t;

typedef db_t *dbptr;

extern dbptr init_db AC((unsigned int, unsigned int));	/* Initialize dbase */
extern int   free_db AC((dbptr));			/* Free dbase */
#define	     isdirty_db(db)  (db->flags & DB_DIRTY)	/* Was dbase changed? */
#define	     dirty_db(db)    (db->flags |= DB_DIRTY)	/* Set dirty status */
#define	     clean_db(db)    (db->flags &= ~DB_DIRTY)	/* Reset dirty status */
#define	     size_db(db)     db->n_elements		/* Get database size */

extern dbrec *add_rec AC((dbptr, char *, int));		/* Add record  */
extern int    del_rec AC((dbptr, char *));		/* Delete record */
extern dbrec *get_rec AC((dbptr, char *));		/* Retrieve record */
extern dbrec *first_rec AC((dbptr));			/* Get first record */
#define	      next_rec(db,rec)	rec->next		/* Get next record */

/*
 * Flags/modes affecting the behavior of add_rec():
 */

#define AR_CREATE	0x01		/* Create or replace key in dbase. */
#define AR_NEWONLY	0x02		/* Do not replace key; return NULL. */
#define AR_NOALLOC	0x80		/* Do not allocate and copy key. */


/*
 * Flags contained in the dbrec.flags field:
 */

#define RF_LAST		0x01		/* Last bucket in hash chain. */
#define RF_STATIC	0x02		/* Key is located in static memory. */

/*
 * Flags contained in the db_t.flags field:
 */

#define DB_DIRTY	0x01		/* New record was added to dbase */
