
#include "nc.h"
/*
 *
 * Routines to write data elements out to the source code file
 * Plus routines to manage selected data elements.
 *
 */
 /*
  * Newsclip(TM) Compiler Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip compiler for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed before compiling.
  * A short time evaluation of this product is also permitted.  See the file
  * 'Licence' in the library source directory for details.
  */
bool wants_dist = FALSE;

write_data()
{
	extern bool needs_stat;

	cprintf( "bool needs_stat = %d;\n", needs_stat );
	cprintf( "bool wants_dist = %d;\n", wants_dist );

	dump_header();
	write_ngnames();
	write_patterns();
}

/* write out the newsgroup names referenced by the user */

write_ngnames()
{
	extern struct stringmap thegroups;
	numstring *ourng;
	int groupcount;

	groupcount = 0;
	cout( "char *user_groupnames[] = {\n" );
	for( ourng = thegroups.first; ourng; ourng = ourng->ng_next ) {
		cprintf( "\"%s\",\n", ourng->name );
		groupcount++;
		}
	cprintf( "0 };\n" );
	cprintf( "int user_gcount = %d;\n", groupcount );
}

write_patterns()
{
	extern struct stringmap thepatterns;
	numstring *outpat;
	int patcount;

	patcount = 0;
	cout( "char *user_patterns[] = {\n" );
	for( outpat = thepatterns.first; outpat; outpat = outpat->ng_next ) {
		patrout( outpat->name );
		patcount++;
		cout ( ",\n" );
		}
	cprintf( "0 };\n" );
	cprintf( "int pattern_count = %d;\n", patcount );
}

int
nums_lookup( numsbase, str )
struct stringmap *numsbase;
char *str;
{
	numstring *ngptr;

	ngptr = (numstring *)add_rec( numsbase->dbase, str, AR_CREATE );

	if( ngptr->ngnum )
		return ngptr->ngnum;
	 else  {
		/* build a chain of the newsgroups, in order */
		if( numsbase->counter ) {
			/* putting on a further group */
			numsbase->current->ng_next = ngptr;
			numsbase->current = ngptr;
			}
		 else
			numsbase->first = numsbase->current = ngptr;

		ngptr->ng_next = (numstring *)0;

		return ngptr->ngnum = ++numsbase->counter;
		}
}

struct stringmap thepatterns = { 0,0,0,0 };

int
pat_number( str )
char *str;
{
	return nums_lookup( &thepatterns, str );
}

#define REQUIRED 1		/* number of routines below that 
					really should be there */
/* Handle null definitions for routines that must be present */

char *mustlist[] = {
"article",			/* main article code REQUIRED */
"init",				/* start of program */
"startgroup",			/* start a new newsgroup */
"endgroup",			/* end of a newsgroup */
"post_article",			/* after article accept/reject */
"terminate",			/* termination of program */
"command",			/* programmed commands in pipe mode */
0
};

write_null()
{
	int i;
	symptr defsym;			/* symbol definition for our routine */
	extern dbptr global_symtab;

	/* make sure there's a definition for each of our desired routines.
	   If there is not a local definition in the global symtab, define
	   a null one in the output program. */

	for( i = 0; mustlist[i]; i++ ) {
		defsym = (symptr)get_rec( global_symtab, mustlist[i] );
		if( defsym && defsym->sflags & SF_LOCAL ) {
			if( defsym->decl_type != ST_PROC )
				parerror( "Symbol '%s' must be a procedure", defsym->name );
			}
		 else {
			cprintf( "U%s(){}\n", mustlist[i] );
			if( i < REQUIRED ) 
				fprintf( stderr, "Warning: No definition of procedure '%s'\n", mustlist[i] );
			}
		}
}
