#################################################
# DO NOT EDIT THIS FILE                         #
#################################################

SHELL	=	/bin/sh

SRC	=	gup.c wildmat.c misc.c prune.c help.c mail.c \
		log.c newsgroups.c lock.c rfc822.c posix_gunk.c

OBJS    =       $(SRC:.c=.o)

HDRS	=	gup.h rfc822.h config.h patchlevel.h

DEFS	=	-DCONFIG='"$(CONFIG)"' -DACTIVE_PATH='"$(ACTIVE_PATH)"' \
 -DNEWSGROUPS_PATH='"$(NEWSGROUPS_PATH)"' \
 -DBACKSTOP_MAILID='"$(BACKSTOP_MAILID)"'	\
 -DLOG_MATCH_LIMIT=$(LOG_MATCH_LIMIT) -DUMASK=$(UMASK)

CFLAGS  =       $(P_CFLAGS) $(P_NO_FLAGS) $(P_USE_FLAGS) $(P_INCLUDES) \
	$(DEFS) -DMAIL_COMMAND='"$(MAIL_COMMAND)"'

LDFLAGS =       $(P_LDFLAGS) $(P_LIBS)

LINTFLAGS =     $(P_NO_FLAGS) $(P_USE_FLAGS) $(P_INCLUDES) $(DEFS) \
		-DMAIL_COMMAND='"cat"'

all:	gup

gup:	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) -o $@

# Lazy and safe
$(OBJS):	$(HDRS) Makefile main.mk xmakefile

install:	$(BINDIR)/gup $(MANDIR)/gup.1

$(BINDIR)/gup:	gup
	cp $? $@

$(MANDIR)/gup.1:	gup.1
	cp $? $@

lint:
	$(LINT) $(LINTFLAGS) $(SRC)

kit:
	rm -rf Part??
	(	\
	cd ..	;\
	makekit -s60k -ngup/Part -igup/MANIFEST -h2 -ogup/MANIFEST	\
	-p -t"Check Makefile then run 'make'"	\
	)

clean:
	rm -f $(OBJS) gup core a.out
	rm -f Part??
	rm -f *.BAK
