/*
**  Miscellaneous routines.
*/
#include "gate.h"
#ifdef	RCSID
static char RCS[] =
	"$Header: misc.c,v 1.6 90/03/12 10:34:44 rsalz Exp $";
#endif	/* RCSID */


/*
**  Allocate memory.
*/
align_t
MyAlloc(i)
    int			i;
{
    align_t		p;

    if ((p = (align_t)malloc((unsigned int)i)) == NULL) {
	Fprintf(stderr, "%s:  Could not allocate %d bytes: %s\n",
		Pname, i, Estring());
	exit(EX_OSERR);
    }
    return p;
}


/*
**  Return a printable representation of errno.
*/
char *
Estring()
{
    static char		buff[20];

    if (errno >= 0 && errno < sys_nerr)
	return sys_errlist[errno];
    Sprintf(buff, "Error code %d", errno);
    return buff;
}


/*
**  Free up something that Split() made.
*/
void
SplitFree(p)
    char	***p;
{
    if (p && *p) {
	free((*p)[0]);
	free((char *)*p);
	*p = NULL;
    }
}


/*
**  This is an AWK-style split routine.  If the split character is NULL,
**  we split on space or tab and eat long stretches of same (that is, no
**  null fields will result).  Returns number of fields made.
*/
int
Split(s, p, c)
    register char	*s;
    char		***p;
    register char	c;
{
    register char	*cp;
    register int	blank;
    register int	n;
    register int	i;

    if (s == NULL || *s == '\0') {
	Fprintf(stderr, "%s:  Someone was a pinhead!\n", Pname);
	abort();
    }

    i = strlen(s) + 1;
    cp = NEW(char, i);
    /* This is too much -- we'll realloc what we really need later. */
    i *= sizeof (char*);
    *p = NEW(char*, i);

    if (c == '\0') {
	/* Eat multiple whitespace characters. */
	for (blank = TRUE, n = 0; *s; s++)
	    if (WHITE(*s)) {
		if (!blank)
		    *cp++ = '\0';
		blank = TRUE;
	    }
	    else {
		if (blank)
		    (*p)[n++] = cp;
		*cp++ = *s;
		blank = FALSE;
	    }

	if (n == 0) {
	    (*p)[0] = cp;
	    SplitFree(p);
	    return 0;
	}
    }
    else
	/* Normal case: find all occurrences of "c" and null them as field
	 * terminators; add new string starts to the array of pointers to
	 * strings. */
	for ((*p)[0] = cp, n = 1; *s; s++)
	    if (*s == c) {
		*cp++ = '\0';
		(*p)[n++] = cp;
	    }
	    else
		*cp++ = *s;

    /* Free up the excess space. */
    *p = (char **)REALLOC(*p, (n + 1) * sizeof (char *));
    (*p)[n] = NULL;
    return n;
}



/*
**  Read in a file of lines, dump it into an array of strings.
*/
char **
ReadFile(Name)
    char		*Name;
{
    register FILE	*F;
    register char	**v;
    register char	*p;
    register int	i;
    char		**value;
    char		buff[SM_SIZE];

    /* Open file, count number of lines therein. */
    if ((F = fopen(Name, "r")) == NULL) {
	perror(Name);
	exit(EX_OSFILE);
    }
    for (i = 1; fgets(buff, sizeof buff, F); i++)
	;

    rewind(F);
    for (v = value = NEW(char*, i); fgets(buff, sizeof buff, F); ) {
	if (p = IDX(buff, '\n'))
	    *p = '\0';
	if (buff[0] && buff[0] != '#')
	    *v++ = COPY(buff);
    }

    *v = NULL;
    return value;
}
