/*
	$Id: rtconfig.h,v 1.3 1998/07/05 19:06:15 crosser Exp $

	$Log: rtconfig.h,v $
	Revision 1.3  1998/07/05 19:06:15  crosser
	Fix installation

	Revision 1.2  1998/07/05 00:26:18  crosser
	Change copyright

	Revision 1.1  1998/07/01 05:01:22  crosser
	Initial revision

*/

/*
	WHAT IS IT:
		Implementation of experimental "whoson" protocol
	AUTHOR:
		Eugene G. Crosser <crosser@average.org>
	COPYRIGHT:
		Public domain
*/

/* whoson runtime configuration */

#ifndef RTCONFIG_H
#define RTCONFIG_H

#ifndef DEFAULT_CONFIG 
#define DEFAULT_CONFIG "/etc/whoson.conf"
#endif

struct _cfgrec {
	char *name;
	int (*rtcfg_init)(void **priv);
	int (*rtcfg_next)(char *key,char *val,void **priv);
	int (*rtcfg_end)(void **priv);
	union {
		struct _evdesc (*init) (void *priv);
		int (*connector) (void *priv,char *buf);
	} root;
};

struct _servdesc {
	struct _servdesc *next;
	void *priv;
	union {
		struct _evdesc (*init) (void *priv);
		int (*connector) (void *priv,char *buf);
	} root;
};

extern struct _cfgrec wso_servlist[];

struct _servdesc *wso_read_config(char *fn,int do_server);

#endif
