.\" Whoson API manual page
.\" 
.\" $Id: whoson.conf.man,v 1.4 1998/07/26 14:06:40 crosser Exp $
.\" 
.\" $Log: whoson.conf.man,v $
.\" Revision 1.4  1998/07/26 14:06:40  crosser
.\" allow and deny in client udp
.\"
.\" Revision 1.3  1998/07/12 16:43:57  crosser
.\" New global parameter: cachesize
.\"
.\" Revision 1.2  1998/07/05 23:26:09  crosser
.\" fix typo
.\"
.\" Revision 1.1  1998/07/05 23:24:12  crosser
.\" Initial revision
.\"
.\" 
.\" WHAT IS IT:
.\"	Implementation of "whoson" protocol
.\" AUTHOR:
.\"	Eugene G. Crosser <crosser@average.org>
.\" COPYRIGHT:
.\"	Public domain
.\" 
.TH WHOSON.CONF 5 "06 Jun 1998" WHOSON WHOSON
.SH NAME
whoson.conf \- whoson configuration file
.SH SYNOPSYS
.B /etc/whoson.conf
.SH DESCRIPTION
.B whoson.conf
is the file that controls operation of both
.BR whosond "(8)
daemon and
.BR whoson "(3)
API functions.
.SS General structure
.B whoson.conf
file contains of a serias of entries.  Each entry starts with a line
containing the word
.B server
or
.B client
from the first position, followed by a word specifying the entry type.
Then, there may follow arbitrary number of
.IR keyword "="value
pairs, in the same line or in the continuation lines.  Continuation
lines start with whitespace.  Hash (\c
.B #\c
) character specify the logical end of the line; comment may follow.
All-whitespace lines are ignored.
.SS Server entry
There are currently 4 types of server entries:
.BR tcp ", "udp ", "unix ", and "global ".
.sp
.B tcp
server entry must contain
.IR port "="number
keyword-value pair and may contain
.IR keepalive "="number ", "allow "="pattern ", and "deny "="pattern
pairs.
.sp
.B udp
server entry must contain
.IR port "="number
keyword-value pair and may contain
.IR allow "="pattern ", and "deny "="pattern
pairs.
.sp
.B unix
server entry must contain
.IR port "="path
keyword-value pair and may contain
.IR keepalive "="number
pair.
.sp
.B global
is a special server entry that contains parameters that are not specific
to a particular communication protocol.  Currntly supported global
parameters are
.IR ttl "="number ", "cachesize "="number ", "user "="userid ", "group "="group\ id
.sp
.IR port "="number " or "port "="path
specifies the IP port number to listen on in dotted quad notation,
or path name for UNIX domain socket.
.sp
.IR allow "="pattern
and
.IR deny "="pattern
specify which clients are allowed to the server.
.I pattern
is dotted quad address followed by the number of bits to check after
a slash (\c
.B /\c
) character.  If that many bits of the peer IP address matches the
address specified in the pattern, the pattern is considered matching.
Of matching patterns, the one with maximum number of bits is used.
By default, all clients are denied.
.sp
.IR keepalive "="number
specifies the number of seconds to keep the connection to the client
open when the client does not send any requests.  This is only
applicable to streaming connection protocols.
.sp
.IR ttl "="number
is the global parameter specifying the number of seconds to keep
an entry in the database if it is not deleted explicitly.
.sp
.IR cachesize "="number
is the global parameter specifying the maximum number of entries to
keep in the database.
.sp
.IR user "="userid
is the (symbolic) user id to change to after the daemon binds to the
sockets.  It may be wise to set to
.I nobody
for security reasons.  Only will work if the daemon is started by root.
.sp
.IR group "="group\ id
- the same for group.  If not specified, the group of the
.I user
is set.
.sp
.B Example:
.RS
.nf
.B server tcp keepalive=600
.B \tport=9876 allow=123.45.67.0/24
.B \tdeny=123.45.67.89/32
.fi
.RE
.SS Client entry
There are currently 3 types of client entries:
.BR tcp ", "udp ", and "unix ".
.sp
.B tcp
client entry must contain
.IR port "="number " and "address "="addrspec
keyword-value pairs.
.sp
.B udp
client entry must contain
.IR port "="number " and "address "="addrspec
keyword-value pairs and may contain
.IR allow "="pattern ", "inittimeout "="number " and "maxtries "="number
pairs.
.sp
.B unix
client entry must contain
.IR port "="path
keyword-value pair.
.sp
.IR port "="number " or "port "="path
specifies the IP port number to connect in dotted quad notation,
or path name for UNIX domain socket.
.sp
.IR address "="addrspec
specify the IP address of the server in dotted quad notation.
.sp
.IR inittimeout "="number
is the initical timeout in microseconds to wait for the server responce.
After timeout is expired, the request is resent and the timeout is
doubled.
.sp
.IR maxtries "="number
is the number of retries to make is the server does not respond.
.sp
.IR allow "="pattern ", and "deny "="pattern
for the
.B udp
client specify the set of IP addresses from which the server responce
is allowed.  If not present, the server address must exactly match
the
.I address
value.  Specifying different set of addresses may be necessary if the
server has multiple IP interfaces and there is no way to predict which of
them will be used as the source address in the UDP packet.
.sp
All configured entries are tried in order until a working one is found. 
.sp
It may be wise to avoid
.B tcp
connection protocol because of considerable startup overhead and because
if destination host is not responding, it may take very long time for
connect() to detect failure.
.sp
.B Example:
.RS
.nf
.B client udp
.B \tport=9876
.B \taddress=123.45.67.89
.B \tinittimeout=200000
.B \tmaxtries=3
.fi
.RE
.SH COPYRIGHT
Public domain
.SH SEE ALSO
.BR whoson "(3), " whosond "(8)
