#include <sys/types.h>
#include "whosond.h"
#include "rtconfig.h"

int tcp_serv_cfg_init(void **priv);
int tcp_serv_cfg_next(char *key,char *val,void **priv);
int tcp_serv_cfg_end(void **priv);
struct _evdesc tcp_serv_init(void *priv);

int udp_serv_cfg_init(void **priv);
int udp_serv_cfg_next(char *key,char *val,void **priv);
int udp_serv_cfg_end(void **priv);
struct _evdesc udp_serv_init(void *priv);

int unix_serv_cfg_init(void **priv);
int unix_serv_cfg_next(char *key,char *val,void **priv);
int unix_serv_cfg_end(void **priv);
struct _evdesc unix_serv_init(void *priv);

int global_serv_cfg_init(void **priv);
int global_serv_cfg_next(char *key,char *val,void **priv);
int global_serv_cfg_end(void **priv);
struct _evdesc global_serv_init(void *priv);

struct _cfgrec wso_servlist[] = {
	{"tcp",tcp_serv_cfg_init,tcp_serv_cfg_next,
				tcp_serv_cfg_end,{tcp_serv_init}},
	{"udp",udp_serv_cfg_init,udp_serv_cfg_next,
				udp_serv_cfg_end,{udp_serv_init}},
	{"unix",unix_serv_cfg_init,unix_serv_cfg_next,
				unix_serv_cfg_end,{unix_serv_init}},
	{"global",global_serv_cfg_init,global_serv_cfg_next,
				global_serv_cfg_end,{global_serv_init}},
	{(void*)0,(void*)0,(void*)0,(void*)0,{(void*)0}}
};
