/* relay-blocking policy tests;  Added for ZMailer 2.99.44 by Matti Aarnio
   on 16-Dec-96 */

/* Pre-included before including this:
     - all type-defining files
     - *DB* headers
 */

struct policystate {
  int dummy;	/* Part of SS structure */
};


#ifdef _POLICYTEST_INTERNAL_

typedef enum { _dbt_none, _dbt_btree, _dbt_ndbm, _dbt_gdbm } dbtypes;


struct policytest {
  char *dbtype;
  char *dbpath;
  dbtypes dbt;
  union {
#ifdef HAVE_NDBM_H
    DBM *_ndbm;
#endif
#ifdef HAVE_GDBM_H
    GDBM_FILE _gdbm;
#endif
#ifdef HAVE_DB_H
    DB *_db;
#endif    
  } db_;
#define btree db_._db
#define gdbm  db_._gdbm
#define ndbm  db_._ndbm
};

#else  /* This is the external interface -- doesn't tell a thing ;-) */

struct policytest {
  void *dummy;
};

#endif

typedef enum {
  POLICY_HELONAME,
  POLICY_SOURCEADDR,
  POLICY_MAILFROM,
  POLICY_RCPTTO
} PolicyTest;

/* Test return values:
     <0 : Always reject
     =0 : Accept
     >0 : Accept with warning..
 */

extern void policydefine   __((struct policytest **relp, char *dbtype, char *dbpath));
extern int  policytest     __((struct policytest *rel, struct policystate *ps, PolicyTest how, char *str));
extern int  policytestaddr __((struct policytest *rel, struct policystate *ps, PolicyTest how, struct sockaddr *raddr));

extern struct policytest *policydb;
