/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#include "hostenv.h"
#include <stdio.h>
#include <sys/param.h>
#include <syslog.h>

extern int errno;
extern char *progname;

/*VARARGS*/
void
warning(fmt, arg, arg2, arg3, arg4)
	char *fmt, *arg, *arg2, *arg3, *arg4;
{
	static int isopen = 0;
	int e = errno; /* Save it over the openlog() .. */

	if (progname != NULL)
		(void) fprintf(stderr, "# %s:%d: ", progname, getpid());
	fprintf(stderr, fmt, arg, arg2, arg3, arg4);
	fprintf(stderr, "\n");
#if 0 /* Actually DON'T syslog this stuff! */
	if (!isopen) {
		openlog(progname, 0, LOG_MAIL);
	}
	errno = e;
	syslog(LOG_ERR, fmt, arg, arg2, arg3, arg4);
#endif
}
