/* --------------------
	vmail -- low.c

	Low level screen update and data structure update routines, other
	similar stuff.

	Copyright (C) J. Zobel, University of Melbourne, October 1987.
-------------------- */

#include "defs.h"

/* --------------------
	Get string from terminal (visibly).
-------------------- */
void
get_string(mes, str)
	char	*mes, *str;
{
	char	c;
	int		i;

	move(STATUS, 0);
	clrtoeol();
	addstr(mes);
	refresh();
	for(i=0 ; (c = getchar()) != '\n' && c != '\r' && c != ESC ; )
		if(i > 0 && c == '\b') {
			i--;
			mvaddch(STATUS, strlen(mes)+i, ' ');
			move(STATUS, strlen(mes)+i);
			refresh();
		} else if(c != '\b') {
			str[i++] = c;
			addch(c);
			refresh();
		}
	str[i] = '\0';
	move(y, 0);
}


/* --------------------
	Put string on status line.
-------------------- */
void
addstatus(str, stand)
	char	*str;
	bool	stand;
{
	move(STATUS, 0);
	clrtoeol();
	if(stand)
		standout();		/* doesn't do anything? */
	addstr(str);
	if(stand)
		standend();
	move(y, 0);
	refresh();
}


/* --------------------
	Fudge deleteline because curses wont delete the line immediately
	after a ^Z, and because it doesnt clear the last line of the screen.
-------------------- */
void
deleteline()
{
	mvaddstr(y, 0, "scribble");
	deleteln();
	move(FIRST+lines-1, 0);
	clrtoeol();
	move(y, 0);
}


int
putch(c)
	char	c;
{
	putchar(c);	/* turn macro into routine */
}


/* --------------------
	Put prompt on screen, wait for getchar().
-------------------- */
int
use_prompt(win)
	WINDOW	*win;
{
	int		c = (cols-42)/2;

	mvwaddstr(win,FIRST+lines-1,c,"-- hit space to continue, q to quit -- ");
	wrefresh(win);
	return(getchar());
}


/* --------------------
	Put info for mail item on screen at row i.
-------------------- */
void
show_title(str, i, mail)
	char	*str;
	int		i;
	item	mail;
{
	sprintf(str, "%4d%s", mail->number, mail->title);
	mvaddstr(i, 0, str);
}


/* --------------------
	Put header for page at top of screen.
-------------------- */
void
add_page_header(str)
	char	*str;
{
	sprintf(str, "%s (page %d of %d) ", curflr->name, curflr->pagenum,
															curflr->pages);
	mvaddstr(TITLE, 0, str);
}


/* --------------------
	Flush typeahead.
-------------------- */
char
flushin()
{
	struct sgttyb sg;

	if(do_flush) {
		ioctl(0, TIOCGETP, &sg);
		ioctl(0, TIOCSETP, &sg);
	}
	return(getchar());
}


/* --------------------
	Print message, wait for getchar();
-------------------- */
void
hold_end()
{
	tputs(SO, 1, putch);
	printf("-- any character to continue --");
	tputs(SE, 1, putch);
	fflush(stdout);
	getchar();
}


#define ctol(c)		(((c) >= 'A' && (c) <= 'Z') ? c-'A'+'a' : c)

/* --------------------
	Case independent strncmp.
-------------------- */
lstrncmp(s1, s2, n)
	char *s1, *s2;
	int n;
{
	for( ; ctol(*s1) == ctol(*s2) && n > 0 ; s1++, s2++, n--)
		;
	return((n > 0) ? *s1 - *s2 : 0);
}


/* --------------------
	String processing - more useful form of index.
	Skip current non-white then skip white, replacing by null.
-------------------- */
char *
next_token(t)
	char	*t;
{
	for( ; *t != ' ' && *t != '\t' && *t != '\0' ; t++)
		;
	for( ; *t == ' ' || *t == '\t' ; t++)
		*t = '\0';
	return(t);
}
