# pr_help.pl -- auto-configuring HELP message
# SCCS Status     : @(#)@ pr_help.pl	1.6
# Author          : Johan Vromans
# Created On      : Sun Dec 13 21:29:38 1992
# Last Modified By: Johan Vromans
# Last Modified On: Sat Jan  2 15:01:57 1993
# Update Count    : 54
# Status          : OK

# Auto-configuring help message.
#
# The help texts are contained in array @help_msgs (standard commands)
# and @ext_help (extended commands). The format for both arrays is the
# same:
# 
#   +COMMAND NAME
#   text line
#   text line
#   ...
#   +COMMAND NAME
#   text line
#   ...
# 
# A lone '+' causes an blank line to be written.
#
# User extensions should call &add_help to add help texts to the help
# system. 

sub do_help {

    local ($line, $cmd) = '';

    &setup_help unless defined @help_msgs;

    select (STDOUT);
    $~ = HELP_LINE;

    print STDOUT ('Valid server commands are:', "\n\n");

    unshift (@help_msgs,
	     '+BEGIN',
	     'Discard anything above this line, and start processing commands.',
	     '+HELP',
	     'This message.',
	     "\n",
	     'Use "send HELP" for a more detailed description on',
	     'how to use the mail server.');

    push (@ext_help,
	  '+END',
	  'Terminate command processing.',
	  'The remainder of the input will be ignored.',
	  '+',
	  '+Case is not significant in the command verbs, '.
	  'but it *IS* significant',
	  '+in <path> and <item> specifications.');
    push (@ext_help,
	  '+',
	  '+Mail messages originating from the any of the following accounts',
	  '+will be discarded (without notice)'.
	  ($black_list_warning ? ' in the future:' : ':'),
	  @black_list
	  ) if defined @black_list;

    foreach ( @help_msgs, @ext_help, '+', '+' ) {
	if ( /^\+/ ) {
	    if ( $cmd ne '' || $line =~ /[^ ]/ ) {
		$= = 999;
		foreach $text ( split (/\n/, $line) ) {
		    $text = $' if $text =~ /^ +/;
		    $text =~ s/ +/ /g;
		    write;
		    $cmd = '';
		}
	    }
	    else {
		print STDOUT "\n";
	    }
	    $cmd = $';
	    $line = ' ';
	}
	else {
	    $line .= $_ . ' ';
	}
    }


    $didhelp = 1;
}

sub setup_help {
    local ($tmp);
    local ($o_host) = $ftp ? '[<host>:]' : '';

    push (@help_msgs,
	  '+REPLY <address>',
	  'Specify return address for replies.',
	  'Use this if you are not sure that',
	  'your mail system generates correct return addresses.');

    push (@help_msgs,
	  '+MAIL <address>',
	  'Requests will be sent via email to <address>.');
    push (@help_msgs,
	  'This is the default.')
	if (defined $email && defined $uucp && !$prefer_uucp);

    push (@help_msgs,
	  '+UUCP <host>!<path> <user>',
	  'Requests will be sent via uucp to <host>!<path>.',
	  'The <user> on <host> will be notified.',
	  '<path> must be writable by the UUCP system on <host>.')
	if $uucp;
    push (@help_msgs,
	  "\n",
	  'A UUCP command *MUST* be issued before any requests.')
	if $uucp && !defined $email;

    $tmp = '';
    $tmp .= "$email_limits[1]K bytes for email" if defined $email;
    $tmp .= ' and ' if defined $email && defined $uucp;
    $tmp .= "$uucp_limits[1]K bytes for UUCP" if defined $uucp;
    push (@help_msgs,
	  '+LIMIT <number>',
	  'Maximum number of Kbytes to be sent per transfer.',
	  "Default is $tmp.\n",
	  'The limit applies to subsequent "send" commands.');

    $tmp = '[ENCODING] {';
    $tmp .= ' BTOA |'		if -x $btoa;
    $tmp .= ' UUE |'		if -x $uue;
    $tmp .= ' XXENCODE |'	if -x $xxencode;
    $tmp .= ' UUENCODE }';
    push (@help_msgs,
	  "+$tmp",
	  'Specify encoding to be used.',
	  'Default is UUENCODE.',
	  'The encoding applies to subsequent "send" commands.');

    push (@help_msgs,
	  '+CWD [<path>]',
	  'Sets or cancels the current working directory',
	  'for subsequent commands.');

    push (@help_msgs,
	  "+DIR $o_host[<path>]",
	  'Returns a list of files in <path>.');
    push (@help_msgs,
	  "\n", 'If a hostname is specified, retrieve the info',
	  'from <host> using anonymous FTP.')
	if $ftp;

    push (@help_msgs,
	  '+INDEX [<item>...]',
	  'Look up everything in the archives that matches the <item>s.',
	  'If no <item>s are specified, requests for a file named "INDEX".')
	if defined $indexfile;

    push (@help_msgs,
	  '+SEARCH <item> [<item>...]',
	  'Look up the indicated archive entries, and return a list of',
	  'files found.');

    push (@help_msgs,
	  "+SEND $o_host<item> [<item>...]",
	  'Specify the items to be sent.');
    push (@help_msgs,
	  "\n", 'If a hostname is specified, retrieve the files',
	  'from <host> using anonymous FTP.')
	if $ftp;

    push (@help_msgs,
	  "+RESEND $o_host<item> <part> [<part>...]",
	  'Re-sends the indicated <parts> from the specified <item>.',
	  'The encoding and limit must be identical to those used in the',
	  'original request.');
    push (@help_msgs,
	  "\n", 'If a hostname is specified, retrieve the files',
	  'from <host> using anonymous FTP.')
	if $ftp;

    push (@help_msgs,
	  '+FTP USER <user> <password>',
	  'Set login information for subsequent FTP commands.',
	  '+FTP OPEN <host>',
	  'Open FTP connection to the indicated <host>.',
	  'If no login information was supplied, use anonymous FTP.',
	  "\n",
	  'If an FTP connection is open, subsequent commands',
	  '(SEND, RESEND, DIR, CWD) will be executed on <host>.',
	  '+FTP CLOSE',
	  'Close any open FTP connection.')
	if $ftp;

    push (@help_msgs,
	  '+ARCHIE PROG <request>',
	  'Consult Archie for <request> (a regular expression pattern).')
	if $archie;

    if ( defined $packing_limit ) {
	$tmp = 'PACK {';
	$tmp .= ' TAR |' if -x $tar || -x $pdtar;
	$tmp .= ' ZOO |' if -x $zoo;
	$tmp .= ' ZIP |' if -x $zip;
	$tmp .= ' OFF }';
	push (@help_msgs,
	      "+$tmp",
	      'Subsequent requests must specify directories,',
	      'which will be packed using the indicated method',
	      'and transferred.',
	      "\n", 'PACK OFF cancels packing.');
    }
}

format HELP_LINE =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<~
$cmd
~~  ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$text
.

1;
