# mserv_config.pl -- config info for mail server
# Author          : Johan Vromans
# Created On      : ***
# Last Modified By: Johan Vromans
# Last Modified On: Sat Jan  2 14:18:04 1993
# Update Count    : 74
# Status          : OK

################ Preamble ################
 #
 # Owner of the mail server. Must be set.
 # This user need no special privileges, except for write access to the
 # mail server files, and read access to the archives.
 # It will get email about problem situations.
$mserv_owner = "mserv";

################ Reply section ################
 #
 # The mail server sends replies to the sender of messages.
 # It could use the current user id as its own address, but usually it
 # is better to substitute something else to prevent bounced mail
 # messages clobbering your system.
 #
 # Your domain. Unfortunately there is no reliable way of fetching this
 # from the system info.
$domain = "mh.nl";
 #
 # Sender of the messages. Try to prevent annoying bounced messages.
$mserv_sender = (getpwnam($mserv_owner))[6] || "Mail Server";
$sender = "From: $mserv_sender <bit-bucket@$domain>";
 #
 # Mail server bcc id.
 # If set, this user gets a Bcc of each request. Can be used for
 # accounting, or to keep track of functionality.
$mserv_bcc = $mserv_owner;
 #
 # Sendmail functionality. Will be called with the recipients on the
 # command line, and a pre-formatted message (including some headers) on 
 # standard input.
 # NOTE: Do not use `-t' if you're running smail3. It will exclude the
 #	named recipients from delivery.
$sendmail = "/usr/lib/sendmail";
 #
 # Optional mail headers.
 # Undefine if not wanted.
@x_headers = ("X-Server: $my_package [$my_name $my_version]",
	      "X-Info: Send mail to <postmaster@$domain>");
 #
 # Sometimes system users (daemons) can send unsollicited messages.
 # The next list holds the names of users whose messages will be 
 # discarded without notice. 
 # Leave it undefined if this feature is not needed.
@black_list = ("root", "uucp", "mailer", "MAILER-DAEMON", "news",
	       "daemon", "demon", "deliver", "sendmail");
 #
 # Define $black_list_warning if you only want to supply a warning.
$black_list_warning = 1;

################ Listener section ################
 #
 # When a mail message is received by the mail server, it is piped into
 # program 'listener'.
 # This program changes uid to the mail server owner, and executes
 # the 'process' program.
 #
 # Define $have_setruid if you have the setruid/setguid system calls.
 # In this case, the program needs to be installed setuid to the
 # mail server owner. If you do not define $have_setruid, the program has to
 # be installed setuid 'root'.
$have_setruid = 1;
 #
 # Define $have_setenv if you have the setenv(3) library call. Using
 # setenv is optional.
$have_setenv = 1;
 #
 # If you $have_setruid, you may define $use_uid also.
 # In this case the getpw* routines will not be used and
 # your executable will be significantly smaller and faster.
$use_uid = 1;

################ Email section ################
 #
 # The default strategy for the mail server is to transfer requests
 # via email. If you set this to zero, $uucp must be defined, and the
 # server will deliver via UUCP only.
$email = 1;
 #
 # Sendmail functionality. Will be called with the recipients on the
 # command line, and a pre-formatted message (including some headers) on 
 # standard input.
 # NOTE: Do not use `-t' if you're running smail3. It will exclude the
 #	named recipients from delivery.
 # Used by "dorequest" to transmit chunks of data via email.
$chunkmail = "/usr/lib/sendmail -odq";
 #
 # The minimum,default,maximum size of email chunks in K.
@email_limits = (10,64,1024);
 #
 # To prevent overloading the system by firing too many sendmails,
 # use this amount to sleep between sending chunks.
$mailer_delay = 30;

################ UUCP section ################
 #
 # The mail server can transfer requests via uucp to systems that are
 # connected that way. This is very efficient compared to email, e.g. 
 # no encoding overhead.
 #
 # Define '$uucp' if you want to use the uucp feature.
 # Append uucp grade, if desired (and your uucp supports it).
 # If you do not define $uucp, requests will be send via email.
$uucp = "/usr/bin/uucp -ga";
 #
 # Prefer UUCP transfer, if possible.
$prefer_uucp = 1;
 #
 # Uucp host names can be checked for validity, if desired.
 # This is how to get a list of uucp host names. 
 # Set it to empty if you do not want to check the host names.
$uuname = "/usr/bin/uuname";	# Check host names.
 #$uuname = "";			# Do not check host names.
 #
 # The minimum,default,maximum size of uucp chunks in K.
@uucp_limits = (10,256,2048);
 #
 # Your uucp host name, if appropriate
#$uuname = "sun4nl";		# static
chop ($uucp_name = `uuname -l`) if defined $uucp;	# dynamic

################ FTP section ################
 #
 # The mail server can fetch files via FTP.
$ftp = 1;
 #
 # The mail server tries to cache files retrieved via FTP, so
 # subsequent requests can be retrieved from the cache.
 # Before transferring a file from the cache, the file is verified to
 # matche the file on the FTP host.
 # Define $ftp_cache to specify where to cache the transferred files.
 # Do not define it to disable caching.
$ftp_cache = "$libdir/ftp";
 #
 # Number of days a file is kept in the cache. Zero means: forever.
 # Time is measured since last access.
$ftp_keep = 8;
 #
 # To reduce overhead, FTP requests may be restricted delivery via UUCP.
$ftp_uucp_only = 1;

################ Archives section ################
 #
 # Where to find the archive entries.
@libdirs = ("/usr/local/src", "/beethoven/arch", "/users/jv/PD");
 # Please add mail server 'pub'!
push (@libdirs, "$libdir/pub");
 #
 # Extensions we recognize. See "$dofilesearch" below.
@exts = (".TZ", ".tar.Z", ".tar", ".shar.Z", ".shar", ".Z",
	 ".zoo", ".zip", ".arc", ".sit");

################ Search strategies ################
 #
 # $dofilesearch: 
 #   Look for file: XXX must exist as file XXX in some lib dir.
 #   Known extensions are also tried.
 #   This is default if no other strategies are selected.
 #
 # $doindexsearch:
 #   Lookup XXXNNNYYY in $indexfile. 
 #   If $indexfile is a relative filename, every lib dir is supposed to
 #   have one. 
 #   If $indexfile is an absolute filename, the location it appears in
 #   will be considered part of the archives. This can be overridden with
 #   $indexlib.
 #
 # $dodirsearch:
 #   Look in dir: XXX or XXXNNNYYY (where NNN is a version indicator,
 #   e.g. '-1.02' and YYY a known extension, e.g. '.tar.Z') must exist
 #   in some lib dir, or subdir XXXNNN.
 #   Example: 'gcc' matches 'gcc', 'gcc.tar.Z', 'gcc-2.1.tar.Z',
 #            'gcc-2.1/gcc.tar.Z' etc.
 #
 # If your index matches the archives (as specified in @libdirs), you
 # can safely set $dodirsearch to 0.
 #
$indexfile = "ix.codes";	# index file per archive directory
#$indexfile = "$libdir/ix.codes";	# separate index file 
#$indexlib  = $libdirs[0];		# archive for index file
 #
 # Subdirs of libdirs we do NOT want in the index files.
 # This is a list of gfind regexps, one per corresponding archive lib.
 # This is used by `makeindex' only.
@libprunes = ();
 #
$dofilesearch = 1;
$doindexsearch = defined $indexfile;
$dodirsearch = 1;
 #
 # If doindexsearch is selected, index searches can return a huge amount
 # of information. Therefore enforce a limit on the max. number of lines
 # an index request can return. Zero means: no limit.
 # Each time an index search exceeds the limit, it is lowered to half the 
 # value it had. This is to avoid excessive results.
$maxindexlines = 200;
 #
 # Set auto_compress to 1 if a request for 'file.Z' is honoured if
 # 'file.Z' does not exists, but 'file' is found. 
 # 'file' will be compressed before transfer.
 # Set it to 2 if 'file.Z' may even result in 'file.shar.Z' or 'file.zoo.Z'...
$auto_compress = 1;

################ The mail server files ################
 #
 # No need to change these, I suppose.
 #
 # Where to store requests.
$queue = $libdir . "/queue";
 # Where to log. Undefine if you do not want logging.
 # Note -- you can override this at run-time with 'doreqest -nolog'.
 #         'chmod -w $logfile' also works.
$logfile = $libdir . "/logfile";
 # Lock file to guard against multiple executions of 'dorequest'.
$lockfile = $libdir . "/lockfile";
 # notes file. Will be prepended to each confirmation message.
 # NOTE: if you change this, you'll need to change the Makefile also.
$notesfile = $libdir . "/mserv.notes";
 # hints file. Will be appended to each confirmation message.
 # NOTE: if you change this, you'll need to change the Makefile also.
$hintsfile = $libdir . "/mserv.hints";

################ Locking section ################
 #
 # Select a locking method. Not selecting a locking method
 # voids your warranty.
 #
 # fcntl(2) locking. Requires "errno.ph" and "fcntl.ph".
$lock_fcntl = 1;
 #
 # BSD style flock(2). Requires "errno.ph" and "sys/file.h".
#$lock_flock = 1;
 #
 # lockf(2) locking. Requires "errno.ph", "unistd.ph" and "sys/syscall.ph".
#$lock_lockf = 1;

################ Encoding programs ################
 #
 # Default encoding. Select one of B, U, D, X and make sure the
 # corresponding encoding tool exists.
$default_encoding = "U";	# uuencode
 #
 # Encoding programs. Supply a full pathname.
 # Encoding commands will be disallowed if the corresponding
 # encoding program is not available.
 # Since uuencode is fixed, it should better be there!
$btoa     = "/usr/local/bin/btoa";	# btoa/atob
$uuencode = "/usr/bin/uuencode";	# uu{en.de}code
$uue      = "/usr/local/bin/uue"; 	# Dumas uue/uud program
$xxencode = "/usr/local/bin/xxencode"; 	# xx{en.de}code

################ Index section ################
 #
 # The following are only needed if you select indexsearch.
 # `makeindex' uses the GNU find program and locate tools.
 # The actual index lookup is performed by GNU locate 3.6 (or later)
 # or a customized version of GNU locate 3.5. In the latter case,
 # you need to "make ixlookup" and "make install-ixlookup".
$gfind = "/usr/local/bin/gfind";
 # The GNU locate library (used to find bigram and code).
$locatelib = "/usr/local/lib/locate";
#$ixlookup = $libdir . "/ixlookup";	# based on GNU locate 3.5
$ixlookup = "/usr/local/bin/locate";	# as of GNU locate 3.6

################ Packing section ################
 #
 # The following are only needed if you want to support the packing 
 # of directories.
 #
 # Max number of blocks in a directory (as returned by 'du -s').
 # Undefine (or set to zero) if you do not want to support packing.
$packing_limit = 4100;
 #
 # Set $auto_packing if a request for 'foo.tar.Z' may automatically
 # pack directory 'foo'.
$auto_packing = 1;
 #
 # Tools.
$du       = "/bin/du";			# get size of dir
$find     = "/usr/local/bin/gfind";	# find
 # If you do not have 'pdtar', undefine it and the mail server will use
 # $tar and $compress instead.
$pdtar    = "/usr/local/bin/pdtar";	# create compressed ustar
$tar      = "/bin/tar";			# if no $pdtar...
$compress = "/usr/ucb/compress";	# if no $pdtar...
$zoo      = "/usr/local/bin/zoo";	# zoo
$zip      = "/usr/local/bin/zip";	# zip

################ Local commands section ################
 #
 # Command to produce a useful listing of files.
$dircmd = "/bin/ls -lL";
 #
 # Command to call Archie.
$archie = "archie";
 #
 # Limit (in K) for command output to be included in the feedback
 # mail.  If it is bigger, it will be compressed and transferred.
 # Zero disables the limit.
$fb_limit = 8;
 #
 # Define $compress to the name of the compress command.
 # It should read from stdin and write to stdout.
 # This is needed for auto-compress and compress/tar functionality.
$compress = "/usr/ucb/compress";

################ Miscellaneous ################
 #
 # Working directory. Should have space for at least 1.5 times the
 # biggest file in the archives...
 #
$tmpdir = $ENV{"TMPDIR"} || "/usr/tmp";

 # Should "dorequest" be run automatically after completion of
 # "process"?
$auto_runrequest = 1;

 # Shall we be nice? This applies to the processing of the requests,
 # as well as to the queue run. Legitimate values are -20..20, but
 # only the superuser can raise the priority using negative values.
$nice = 10;

 # It is possible to add user defined commands to the mail server.
 # See the documentation for details.
#$cmd_extend = $libdir . "/userdefs.pl";

 # For debugging, it is sometimes necessary to trace the mail headers.
 # Note: the $trace_file must exist.
$trace_headers = 0;
$trace_file = $libdir . "/tracefile";

################ End of configuation info ################

1;
