# ms_common.pl -- common info for mail server
# SCCS Status     : @(#)@ ms_common	1.38
# Author          : Johan Vromans
# Created On      : Fri Apr 17 11:02:58 1992
# Last Modified By: Johan Vromans
# Last Modified On: Tue Jan  5 19:43:48 1993
# Update Count    : 110
# Status          : OK

################ Preamble ################
#
# Package info. Do not change this.
$my_package = "Squirrel Mail Server Software V3.01";
#
if ( defined $config_file && $config_file ne '' ) {
    require $config_file;
}
else {
    require "ms_config.pl";
}
require "ms_lock.pl";
#
# It is not always clear if 'not setting' means 'not defining' or
# 'leaving it empty'.
# This guarantees some consistency.

undef $uucp
    unless defined $uucp && $uucp ne "";
$email = 1 unless defined $uucp;
undef $email
    unless defined $email && $email;
$chunkmail = $sendmail
    unless defined $chunkmail && $chunkmail ne "";
$mserv_bcc = ""
    unless defined $mserv_bcc;
undef $sender
    unless defined $sender && $sender ne "";
undef $mailer_delay
    unless defined $mailer_delay && $mailer_delay > 0;
undef $lockfile
    unless defined $lockfile && $lockfile ne "";
undef $lock_lockf
    unless defined $lock_lockf && $lock_lockf != 0;
undef $lock_flock
    unless defined $lock_flock && $lock_flock != 0;
undef $lock_fcntl
    unless defined $lock_fcntl && $lock_fcntl != 0;
undef $sender
    unless defined $sender && $sender ne "";
undef @x_headers
    unless defined @x_headers && @x_headers ne 0;
undef $logfile
    unless defined $logfile && $logfile ne "";
undef $indexfile
    unless defined $indexfile && $indexfile ne "";
undef $indexlib
    unless defined $indexfile && defined $indexlib && $indexlib ne "";
$maxindexlines = 0
    unless defined $maxindexlines && $maxindexlines > 0;
$uuname = ""
    unless defined $uuname;
undef $auto_packing
    unless defined $auto_packing && $auto_packing && $packing_limit > 0;
undef $packing_limit 
    unless defined $packing_limit && $packing_limit > 0;
undef $pdtar
    unless defined $pdtar && $pdtar ne "";
$auto_runrequest = 0
    unless defined $auto_runrequest && $auto_runrequest > 0;
$auto_compress = 0
    unless defined $auto_compress && $auto_compress && $compress;
undef @black_list
    unless defined @black_list && @black_list > 0;

################ Subroutines ################

sub fnsplit {
    local ($file) = @_;
    # Normalize $file -> ($dir, $basename)

    return ($1, $2) if $file =~ /^(\[.*\])(.*)$/;	# VMS

    local (@path) = split (/\/+/, $file);
    (join ("/", @path[0..$#path-1]), $path[$#path]);
}

sub fttemp {
    $int'fttemp = 'aa' unless defined $int'fttemp;
    local ($thefile) = "$tmpdir/ft$$." . $int'fttemp;
    $int'fttemp++;
    $thefile;
}

sub canon_fname {
    local ($fname) = @_;

    # Canonical form for filename.

    if ( $fname =~ /^([-a-z0-9._]+):/i ) {
	&ftp_archname ($1, $');
    }
    else {
	&ftp_archname ('', $fname);
    }
}

sub ftp_archname {
    local ($host, $file) = @_;

    # Transforms host:filename into ftp cache name.

    # Reverse the elements of the host name, and lowcase it.
    local ($result) = '';
    $result = join ('/', reverse(split(/\./,$host))) . '/' if $host;

    if ( $file =~ /^\[(\.?PUB)?([^\]]*)\]([^\[\]]+)$/i ) {
	# VMS file name.
	# $2 contains the path (with [ ] stripped), and
	# $3 the file name. 
	# $1 has been used to strip off an optional leading .PUB.
	$result .= join ('/', split(/\.+/, $2), $3);

	# Lowercase the result.
	$result =~ tr/A-Z/a-z/;
    }
    else {
	# Assume UNIX file name.
	# Strip leading / and pub/ .
	$file = $' if $file =~ m|^/+|;
	$file = $' if $file =~ m|^pub/+|i;

	# Lowcase the host name, and append the file.
	$result =~ tr/A-Z/a-z/;
	$result .= $file;
    }

    # Squeeze multiple slashes.
    $result =~ s|//+|/|g;

    $result;
}

sub writelog {

    # Write message to logfile, if possible, Otherwise use STDERR.

    local (@tm) = localtime (time);
    local ($msg) = sprintf ("%02d%02d%02d %02d:%02d %s\n", 
			    $tm[5], $tm[4]+1, $tm[3], $tm[2], $tm[1], $_[0]);

    if ( !$opt_nolog && defined $logfile && ( -w $logfile ) && 
	open (LOG, ">>" . $logfile) ) {
	if ( &locking (*LOG, 1) ) {
	    seek (LOG, 0, 2);
	    print LOG $msg;
	    close LOG;
	    return unless $opt_debug;
	}
    }

    print STDERR $msg;
}

################ 1 ################
1;

