#!/usr/local/bin/perl
# mlistener.pl -- make listener.c
# SCCS Status     : @(#)@ mlistener.pl	1.7
# Author          : Johan Vromans
# Created On      : Sun May 31 14:22:56 1992
# Last Modified By: Johan Vromans
# Last Modified On: Wed Dec 23 23:03:16 1992
# Update Count    : 29
# Status          : Unknown, Use with caution!

$my_name = "mlistener.pl";
$my_version = "1.7";
#
################ Common stuff ################

$libdir = $ENV{"MSERVLIB"} || "/usr/local/lib/mserv";

################ Options handling ################

$opt_verbose = $opt_ident = $opt_help = 0;
$opt_setruid = $opt_setenv = $opt_uid = 0;
$opt_nosetruid = $opt_nosetenv = $opt_nouid = 0;
&options if @ARGV > 0 && $ARGV[0] =~ /^-+[^-]+/;
require "./ms_common.pl";	# USE CURRENT DIR, NOT LIBDIR!
print STDERR ($my_package, " [", $my_name, " ", $my_version, "]\n")
    if $opt_ident || $opt_verbose;

################ Main ################

$mserv_uid = (getpwnam ($mserv_owner))[2];
die ("Cannot get UID for user $mserv_owner\n") unless defined $mserv_uid;

if ( $opt_verbose ) {
    print STDERR ("Using ", $have_setruid ? "setruid system call" :
		  "'su' program", ".\n");
    print STDERR ("Using setenv library call.\n")
	if $have_setruid && $have_setenv;
    print STDERR ("Change to UID $mserv_uid.\n")
	if $have_setruid && $use_uid;
}

$have_setruid |= $opt_setruid;
$have_setruid = 0 if $opt_nosetruid;
$have_setenv |= $opt_setenv;
$have_setenv = 0 if $opt_nosetenv || !$have_setruid;
$use_uid |= $opt_uid;
$use_uid = 0 if $opt_nouid || !$have_setruid;

require "ctime.pl";
chop ($ctime = &ctime(time));
$uid = $use_uid ? ", uid = $mserv_uid" : "";
$opt = "";
$opt .= " setruid" if $have_setruid;
$opt .= " setenv" if $have_setenv;
$opt .= " useuid" if $use_uid;

print <<EOD;
/* listener - receives mails and passes them to the mail server */

static char *SCCS_id[] = 
    {"@(#)@ Generated by mlistener.pl 1.7 on $ctime",
     "@(#)@ Configuration:",
     "@(#)@     Server  = $mserv_owner$uid",
     "@(#)@     Process = $libdir/process",
     "@(#)@     Options =$opt"};

#include <stdio.h>
EOD
print <<EOD if $have_setruid && !$use_uid;
#include <pwd.h>
EOD
print <<EOD if $have_setruid;
int setruid();
EOD
print <<EOD if $have_setruid && !$use_uid;
int setrgid();
EOD
print <<EOD if $have_setenv;
int setenv();
EOD
print <<EOD;

/* In an attempt to leave some useful tracks upon failure, 
 * we're gonna exit with special values.
 */
#define abend(i)	exit(88+(i))

int chdir();

main (argc, argv)
int argc;
char *argv[];
{
EOD
if ( $have_setruid && $use_uid || $have_setruid ) {
    print <<EOD;
	argv[0] = "process";
EOD
}
if ( $have_setruid && $use_uid ) {
    print <<EOD;
	/* Change identity. */
	if (setruid ($mserv_uid) < 0) abend (1);
EOD
    print <<EOD if $have_setenv;
	setenv ("USER", "$mserv_owner", 1);
	setenv ("LOGNAME", "$mserv_owner", 1);
	setenv ("HOME", "/tmp", 1);
EOD
    print <<EOD;
	if (chdir ("/tmp") < 0) abend (3);

	/* Execute the real listener */
	return execv ("$libdir/process", argv);
	abend (4);
EOD
}
elsif ( $have_setruid ) {
    print <<EOD;
	struct passwd *pw;

	/* Get info from system */
	pw = getpwnam ("$mserv_owner");
	if ( pw == NULL ) {
	  perror ("getpwnam");
	  exit (70);			/* Internal software error */
	}

	/* Change identity. */
	if (setruid (pw->pw_uid) < 0) abend (1);
	if (setrgid (pw->pw_gid) < 0) abend (2);
EOD
    print <<EOD if $have_setenv;
	setenv ("USER", pw->pw_name, 1);
	setenv ("LOGNAME", pw->pw_name, 1);
	setenv ("HOME", pw->pw_dir, 1);
EOD
    print <<EOD;
	if (chdir (pw->pw_dir) < 0) abend (3);

	/* Execute the real listener */
	return execv ("$libdir/process", argv);
	abend (4);
EOD
}
else {
    print <<EOD;
	/* NOTE: arbitrary limits ahead! */
	char *args[64];
	char cmd[512];
	int i = 0;
	args[i++] = "su";
	args[i++] = "$mserv_owner";
	args[i++] = "-c";
	args[i++] = strcpy (cmd, "$libdir/process");
	argv++;
	while ( *argv ) {
	    strcat (cmd, " ");
	    strcat (cmd, *argv++);
	}

	/* Become root so we can so "su" w/o asking */
	if (setuid (0) < 0) abend (10);
	chdir ("/tmp");

	/* Execute the real listener via "su" */
	return execv ("/bin/su", args);
	abend (11);
EOD
}
print "}\n";

################ Subroutines ################

sub options {
    require "newgetopt.pl";
    if ( !&NGetOpt ("setenv", "setruid", "nosetenv", "nosetruid",
		    "uid", "nouid", "config=s",
		    "verbose", "ident", "help")
	|| $opt_help
	|| (@ARGV > 0)) {
	&usage;
    }
    $config_file = $opt_config if defined $opt_config;
}

sub usage {
    require "./ms_common.pl";
    print STDERR <<EndOfUsage;
$my_package [$my_name $my_version]

Usage: $my_name [-help] [-ident]

Options:
    -config XX	  use alternate config file
    -[no]setruid  use (do not use) setruid system call
    -[no]setenv	  use (do not use) setenv library call
    -help	  this message
    -ident	  print identification
    -verbose	  supply verbose information
EndOfUsage
    exit (1);
}
