# dr_uucp.pl -- handle request via uucp
# SCCS Status     : @(#)@ dr_uucp.pl	3.7
# Author          : Johan Vromans
# Created On      : Thu Jun  4 22:22:49 1992
# Last Modified By: Johan Vromans
# Last Modified On: Tue Dec 15 23:12:24 1992
# Update Count    : 25
# Status          : OK

sub uucp_request {

    local ($rcpt, $uupath, $uunote, $request, $file, $encoding, $limit, $parts) = @_;

    if ( $opt_debug ) {
	print STDERR ("&uucp_request(rcpt=$rcpt, uupath=$uupath,\n",
		      "    uunote=$uunote, request=$request,\n",
		      "    file=$file,\n",
		      "    encoding=$encoding, limit=$limit, parts=$parts,",
		      " remove=$remove_file)\n");
    }

    # This routine handles the requests.

    &check_file ($file, 0);

    local ($fname);		# Basename of file to send
    local ($size);		# Size of file
    local ($files);		# Number of files to send
    local (@parts);		# List of parts to send
    local ($tmpfile_prefix) = $opt_keep || "$tmpdir/drq$$.";
    local ($compressed) = '';	# we compressed it

    # Limit must be between 10 and 1024K, with 256K default.
    $limit =   32*1024 unless defined $limit;
    $limit = $` * 1024 if $limit =~ /K$/;
    $limit =   10*1024 if $limit <   10*1024;
    $limit = 1024*1024 if $limit > 1024*1024;

    # Build an acceptable filename for uucp.
    if ( $request =~ m|[\s\047\042?%*{}]| ) {
	$fname = (&fnsplit ($file))[1];
    }
    else {
	if ( index ($request, $tmpdir) == $[ ) {
	    # Get last part (basename) of the requested file.
	    $fname = (&fnsplit ($request))[1];
	}
	else {
	    $fname = &canon_fname ($request);
	}
    }

    # Compress first, if requested.
    if ( $encoding =~ /^[^ap].*z$/i && $compress ) {
	local ($tmp) = &fttemp;
	print STDERR ("Using compression\n") if $opt_debug;
	&system ("$compress < $file > $tmp");
	if ( $remove_file ) {
	    print STDERR ("Unlinking $file\n") if $opt_debug;
	    unlink ($file);
	}
	$remove_file = 1;
	$file = $tmp;
	$compressed = chop ($encoding);
    }

    $size = (stat ($file))[7];
    if ( $size > $limit ) {

	open (F, $file) || &die ("Cannot read $file [$!]");

	$files = int (($size - 1 ) / $limit) + 1;
	print STDERR ("Size = $size, files = $files\n")
	    if $opt_debug;

	if (  $parts =~ /\S/ ) {
	    @parts = grep ($_ && $_ <= $files, split (/,/, $parts));
	}
	else {
	    @parts = (1..$files);
	}
	
	local ($i) = length "$files";
	local ($partfmt) = "part%0${i}dof%0${i}d";
	
	foreach $the_part ( @parts ) {

	    local ($cnt) = 0;
	    local ($need) = $limit;
	    local ($uutmp) = $tmpfile_prefix . "uu";

	    print STDERR ("Sending $file, part $the_part of $files\n")
		if $opt_debug;

	    seek (F, ($the_part-1) * $limit, 0);
	    open (S, ">$uutmp") || &die ("Cannot create $uutmp [$!]");
	    while ( $need > 0 ) {
		local ($try) = 10240;
		$try = $need if $try > $need;
		$res = sysread (F, $buf, $try);
		last unless defined $res && $res > 0;
		syswrite (S, $buf, $res);
		$need -= $res;
		$cnt += $res;
	    }
	    close (S);

	    # Send it (w/ copy to UUCP spool).
	    &system ("$uucp -d -r -C -n$uunote $uutmp ".
		     "$uupath/$fname/".sprintf ($partfmt, $the_part, $files));

	    # Write a log message.
	    $uupath =~ /!/;
	    &writelog ("U \"$`!$uunote\" $request $compressed$the_part".
		       "/$files $cnt");

	    unlink ($uutmp) unless $opt_keep;
	}
	close (F);
    }
    else {
	print STDERR ("Sending file: ", $file, "\n")
	    if $opt_debug;

	# Send it. Prevent copy to spool if possible.
	$cmd = "$uucp -d -r " .
	       ($remove_file ? '-C' : '-c') .
	       " -n$uunote $file $uupath/$fname";

	if ( $opt_nouucp ) {
	    print STDERR ("[Would call \"$cmd\"]\n");
	}
	else {
	    &system ($cmd);
	}

	# Write a log message.
	$uupath =~ /!/;
	&writelog ("U \"$`!$uunote\" $request ${compressed}1/1 $size");
    }

    if ( $remove_file ) {
	print STDERR ("Unlinking $file\n") if $opt_debug;
	unlink ($file);
    }
}

1;
