# dr_pack.pl -- handle packing
# SCCS Status     : @(#)@ dr_pack.pl	3.3
# Author          : Johan Vromans
# Created On      : Thu Jun  4 22:22:49 1992
# Last Modified By: Johan Vromans
# Last Modified On: Sat Dec 12 01:56:08 1992
# Update Count    : 8
# Status          : OK

sub pack_mail_request {
    local ($rcpt, $dest, $uunote, $request, $file, 
	   $coding, $limit, $packing, $parts) = @_;

    if ( $opt_debug ) {
	print STDERR ("&pack_mail_request(rcpt=$rcpt, address=$dest, ",
		      "request=$request,\n",
		      "    file=$file,\n",
		      "    limit=$limit, packing=$packing, parts=$parts)\n");
    }

    ($request, $file) = &packing ($request, $file, $packing);
    require "$libdir/dr_mail.pl";
    &mail_request ($rcpt, $dest, $uunote, $request, $file, 
		   $coding, $limit, $parts);
    unlink ($file) unless $opt_keep;
}

sub pack_uucp_request {
    local ($rcpt, $uupath, $uunote, $request, $file, 
	   $coding, $limit, $packing, $parts) = @_;

    if ( $opt_debug ) {
	print STDERR ("&pack_uucp_request(rcpt=$rcpt, uupath=$uupath,\n",
		      "    uunote=$uunote, request=$request,\n",
		      "    file=$file,\n",
		      "    limit=$limit, oacking=$packing, parts=$parts)\n");
    }

    ($request, $file) = &packing ($request, $file, $packing);
    require "$libdir/dr_uucp.pl";
    &uucp_request ($rcpt, $uupath, $uunote, $request, $file, 
		   $coding, $limit, $parts);
    unlink ($file) unless $opt_keep;
}

sub packing {
    local ($request, $file, $packing) = @_;

    # Packs the files in directory $file into an $packing-archive, and
    # returns an array containing the modified name of the request
    # and the name of the archive file.

    &check_file ($file, 1);

    local ($dir, $realname) = &fnsplit ($file);
    local ($tmpfile_prefix) = $opt_keep || "$tmpdir/pck$$.";
    local ($cmd) = "$find $realname -follow -type f ! -name '.*' -print | ";

    chdir $dir || &die ("Cannot chdir to $dir [$!]");

    if ( $packing eq "tar" ) {
	$file = $tmpfile_prefix . "tar.Z";
	$cmd .= $pdtar ? "$pdtar -z -c -h -T - -f $file"
		: "$tar -c -h -T - -f - | $compress > $file";
	&system ($cmd);
	&die ("Problem executing \"$cmd\"") unless -s $file;
	return ($request . "-tar.Z", $file);
    }

    if ( $packing eq "zoo" ) {
	$file = $tmpfile_prefix . "zoo";
	$cmd .= "$zoo aIqq $file";
	&system ($cmd);
	&die ("Problem executing \"$cmd\"") unless -s $file;
	return ($request . "-zoo", $file);
    }

    if ( $packing eq "zip" ) {
	$file = $tmpfile_prefix . "zip";
	# It is not really necessary to use find for zip,
	# but this is the only way to exclude .-files.
	$cmd .= "$zip -n Z -q -b $tmpdir -@ $file";
	&system ($cmd);
	&die ("Problem executing \"$cmd\"") unless -s $file;
	return ($request . "-zip", $file);
    }

    &die ("Invalid packing code in queue");
    (undef, undef);
}

1;
