# dateconv.pl -- date/time conmversions.
# SCCS Status     : @(#)@ dateconv.pl	1.2
# Last Modified By: Johan Vromans
# Last Modified On: Sat Dec  5 01:32:31 1992
# Update Count    : 1
# Status          : OK

# Convert a date into a time.

sub lstime_to_standard
{
	local( $ls ) = @_;

	return &time_to_standard( &lstime_to_time( $ls ) );
}

package dateconv;

require 'timelocal.pl';

@months = ( "zero", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" );

$month_num{ "Jan" } = 0;
$month_num{ "Feb" } = 1;
$month_num{ "Mar" } = 2;
$month_num{ "Apr" } = 3;
$month_num{ "May" } = 4;
$month_num{ "Jun" } = 5;
$month_num{ "Jul" } = 6;
$month_num{ "Aug" } = 7;
$month_num{ "Sep" } = 8;
$month_num{ "Oct" } = 9;
$month_num{ "Nov" } = 10;
$month_num{ "Dec" } = 11;

( $mn, $yr ) = (localtime)[ 4, 5 ];

# Convert an 'ls' type date string into a time
sub main'lstime_to_time
{
	package dateconv;

	local( $date ) = @_;

	local( $mon, $day, $hours, $mins, $month, $year );

	if( $date =~ /^(\w\w\w)\s+(\d+)\s+((\d\d\d\d)|((\d+):(\d+)))$/ ){
		($mon, $day, $year, $hours, $mins) = ($1, $2, $4, $6, $7);
#print "(mon $mon, day $day, year $year, hours $hours, mins $mins)\n";
	}
	else {
		printf STDERR "invalid date $date\n";
		return time;
	}
	
	$month = $month_num{ $mon };

	if( $year !~ /\d\d\d\d/ ){
		$year = $yr;
		$year-- if( $month > $mn );
	}
	if( $year > 1900 ){
		$year -= 1900;
	}
	 
#print " &timegm( 0, $mins, $hours, $day, $month, $year );\n";
	return &timegm( 0, $mins, $hours, $day, $month, $year );
}

sub main'time_to_standard
{
	package dateconv;

	local( $time ) = @_;

	local( $sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst ) =
		 gmtime( $time );
	return sprintf( "%2d $months[ $mon + 1 ] %2d %02d:%02d", $mday, $year, $hour, $min );
}

1;
