#!/usr/local/bin/perl

# This program has been almost taintified

eval "exec /usr/local/bin/perl $0"
  if $running_under_some_shell;

# @(#)@ process	1.23 - process.pl
#
# This program processes mail messages, and enqueues requests for
# the mail server (dorequest).
#

# Arguments used when running with "perl -s"
# $debug=1;
$debug=0 unless $debug;
$nobatch=0 unless $nobatch;

&source("/usr/local/lib/mailserver/config");
&source("$lib/rfc822.pl");
&source("stat.pl"); $S_IFREG = 0100000;	# regular file
&source("syslog.pl");

$errflag = 0;
$didhelp = 0;

do openlog($syslogname,'cons,pid','local7');
do syslog('INFO', 'Startup..');

# Formats used for displaying request results.

format work_header =
  request                format (uncoded size)  encoding  limit  remarks
  ---------------------  ---------------------  --------  -----  -------
.
format work_list =
  @<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<  @<<<<<<<  @>>>>  @<<<<<<<<<<<<<<<<<<<<<<<<<<<
  $request,             $format,               $coding,  $K,    $remarks
.

$tmpfile = "/tmp/mserv$$";
$limit = $def_limit;
open(stdout, ">" . $tmpfile) || &logdie("Cannot open $tmpfile: $!") if (!$debug);

print "$myname $version\n\n";

do rfc822_start_read ("-") || &logdie("cannot read input");

# flush "From_ line if it's in the cache...
if ( $rfc822_line_in_cache =~ /^From / ) {
  $rfc822_line_in_cache = "";
}

print "Processing mail headers ...\n";

$h_from = ""; $h_reply = ""; $h_subj = "";

while ( do rfc822_not_eof ()) {
  $res = do rfc822_read_header (0);
  last if $res != $rfc822_valid_header;
  $rfc822_header =~ tr/[A-Z]/[a-z]/;
  $h_from = $rfc822_contents if $rfc822_header eq "from";
  $h_subject = $rfc822_contents if $rfc822_header eq "subject";
  $h_reply = $rfc822_contents if $rfc822_header eq "reply-to";
}

$path = $h_from if $h_from ne "";
$path = $h_reply if $h_reply ne "";
print "Return address: \"$path\"\n";

foreach $name (@badnames) {
	&badmsg("Bogus name: $path") if ($path =~ /$name/i);
}

print "\nProcessing message contents...\n\n";

# set defaults
$encode = $defaultencoding;
@work = ();

# formats we can handle
$fmt{".ps"  } = "PostScript";
$fmt{".Z"  } = "Compressed";
$fmt{".TZ" } = "Compressed Tar";
$fmt{".zoo"} = "Zoo";
$fmt{".zip"} = "Zip Archive";
$fmt{".tar"} = "Tar";
$fmt{".shar"} = "Shell Archive";

$commands = 0;
while ( do rfc822_not_eof ()) {
  $res = do rfc822_read_header (1);
  next if $res != $rfc822_data_line;

  # First check for bad commands...
  foreach $cmd (@badcmds) {
      &badmsg("Bogus command: $rfc822_line") if ($rfc822_line =~ /$cmd/i);
  }

  $commands++;
  print "Command: $rfc822_line\n";
  @cmd = split (/[\t ,]+/, $rfc822_line);
  shift (@cmd) if $cmd[0] eq "";	# skip leading null arg, if any

  # Get command verb, shifting past any leading "set" commands.  We do this
  # since some users say "set limit n" rather than just "limit n".  This
  # also upshifts command verbs (e.g: so "exit" == "EXIT" == "Exit".)

  do {
    $cmd = shift (@cmd);
    last unless $cmd;
    $cmd  =~ tr/[a-z]/[A-Z]/;
  } while ( $cmd eq "SET" );


  #
  # exit/end
  #

  if (( $cmd eq "EXIT" ) | ( $cmd eq "END" )) {
    print "=> Okay\n";
    last;
  }

  #
  # path <path>
  #

  if ( $cmd eq "PATH" ) {

    if ( $#cmd == 0 ) {
      $path = $cmd[0];
      print "=> Return address: \"$path\"\n";
    }
    else {
      do errmsg ("PATH takes one argument");
    }
    print "\n";
  }

  #
  # limit [ <number>[K] ]
  #

  elsif ( $cmd eq "LIMIT" ) {

    if ( $#cmd < 0 ) {		# Just set to default limit
      $limit = $def_limit;
      print "=> Limit = $limit\n";
    } elsif ( $#cmd == 0 ) {
      $try = $cmd[0]; $new = -1;

      # See if they said "64000" or "64K"
      if ( $try =~ /^\d+$/ ) {
	$new = 0+$try;
      } elsif ( $try =~ /^(\d+)K$/i ) {
	$new = $1 * 1024;
      }

      if ( $new < 0 ) {
	do errmsg ("LIMIT takes one optional numeric argument");
      } elsif ( ($new < $minlimit) | ($new > $maxlimit) ) {
	do errmsg ("LIMIT must be between $minlimit and $maxlimit");
      } else {
	$limit = $new;
	print "=> Limit = $limit\n";
      }
    } else {	# More than one arg.
      do errmsg ("LIMIT takes one optional numeric argument");
    }
    print "\n";
  }

  #
  # uu{en,de}code
  #

  elsif ( $cmd eq "UUENCODE" || $cmd eq "UUDECODE" ) {
    if ( $#cmd < 0 ) {
      $encode = "uuencode";
      print "=> Encoding = $encode\n";
    } else {
      do errmsg ("$cmd does not take any arguments");
    }
    print "\n";
  }

  #
  # btoa/atob
  #

  elsif ( $cmd eq "BTOA" || $cmd eq "ATOB") {
    if ( $#cmd < 0 ) {
      $encode = "btoa";
      print "=> Encoding = $encode\n";
    } else {
      do errmsg ("$cmd does not take any arguments");
    }
    print "\n";
  }

  #
  # send <item> [ <item>...]
  #

  elsif ( $cmd eq "SEND" ) {
    if ( $#cmd >= 0 ) {
      do {
	$item = shift (@cmd);
	print "=> Send: $item\n";

	push (@work, "$limit $encode $item") if (!&chkspecial($item));
      } while ( $#cmd >= 0 );
    } else {
      do errmsg ("SEND commands needs arguments");
    }
    print "\n";
  }

  #
  # resend <item> <number> [ <number>...]
  #

  elsif ( $cmd eq "RESEND" ) {
    if ( $#cmd >= 1 ) {
      $request = shift (@cmd);
      @plist = ();
      while ( $#cmd >= 0 ) {
	$num = shift (@cmd);
	if ( $num =~ /^\d+$/ ) {
	  push (@plist, 0+$num);
	} else {
	  do errmsg ("RESEND commands needs an item and a list of numbers");
	  last;
	}
      }
      print "=> Resend: $request, part",
	    ($#plist > 0) ? "s " : " ", join (",", @plist), "\n";

      push (@work, "$limit $encode $request " . join (",", @plist))
	    if (!&chkspecial($request));
    } else {
      do errmsg ("RESEND commands needs an item and a list of numbers");
    }
    print "\n";
  }

  #
  # help
  #

  elsif ( $cmd eq "HELP" ) {
    if ( $#cmd < 0 ) {
      do help();
    } else {
      do errmsg ("HELP does not take any arguments");
    }
    print "\n";
  }

  #
  # test
  #

  elsif ( $cmd eq "TEST" ) {
    if ( $#cmd < 0 ) {
      $nobatch = 1;
      print "=> Okay\n";
    } else {
      do errmsg ("Command $cmd unknown");
    }
    print "\n";
  }

  #
  # .signature follows?
  #

  elsif ( $cmd eq "--" ) {
    print "=> Assume a USENET .signature follows; I'll ignore the rest of the message\n";
    last;
  }

  #
  # unknown command
  #

  else {
    do errmsg ("Command $cmd unknown");
    print "\n";
  }
}

print "\nYour message has been processed.\n";

if ( $commands == 0 ) {
  print "No commands were found.\n";
  do help();
} elsif ( $errflag ) {
  print "Number of errors detected = $errflag.\n";
  print "NO FILES WILL BE SENT.\n";
  do help();
} else {
  $^ = "work_header";	# Top of page format
  $~ = "work_list";	# report format
  $entries = 0;

# At this point @work holds all the requests.  Each request
# contains the following blank-separated fields:
#	limit on size of transfer
#	Encoding method
#	The requested file
#	parts to be transferred (optional)

  if ( $#work >= 0 ) {
    print "The following request", 
	($#work > 0 ) ? "s have" : " has",
	" been queued:\n\n";
  }

  while ( $#work >= 0 ) {
    @tmp = split (/ /, shift (@work));

    $K = int((1023+$tmp[0])/1024) . "K";
    $coding = $tmp[1];
    $request = $tmp[2];

    if ( $#tmp > 2 ) { $plist = $tmp[3]; }
    else { $plist = ""; }

    $format = "Unknown";
    $remarks = "";

    # pass thru the libdirs to find the requested file
    findfile:
      for (@libs = @libdirs; $#libs >= 0, $libdir = shift (@libs); )  {
      $libdir .= "/";
      print "using lib: $libdir\n" if $debug;

      $st_size = 0;
      $the_file = $libdir . $request;

      # prevent security leak
      last findfile if index ($the_file, "/../") >= 0;

      # first, try the filename "as is"
      if ( do Stat ($the_file) && ($st_mode & $S_IFREG) ) {

	# found it - assume text file
	$format = "Plain";

	# find out if one of the format extensions matches the filename
	# note: cannot use "foreach" in perl2
	@k = keys (fmt);
	while ( $#k >= 0 ) {
	  $f = shift (@k);
	  if ( $the_file =~ /$f$/ ) {
	    # it does - adjust format and exit the search
	    $format = $fmt{$f};
	    last findfile;
	  }
	}

	# no match on extension, oh well..
	if ( ($request eq "HELP") | ($request eq "INDEX") ) {
	  $coding = "plain";
	  $K = "";
	}
	last findfile;
      } else {
        # File did not exist as is
	# append each of the known extensions until a file is found
	# do not use "foreach" here either

	@k = keys (fmt);
	while ( $#k >= 0 ) {
	  $f = shift (@k);
	  if ( do Stat ($the_file . $f) ) {
	    # we have one.
	    # adjust the format, request name, and exit the search
	    $format = $fmt{$f};
	    $request .= $f;
	    $the_file .= $f;
	    last findfile;
	  }
	}
      }
    }

    # have we found something?
    if ( $format eq "Unknown" ) {

      $coding = "";
      $K = "";
      $remarks = "Request skipped";

    } else {

      print "File: $the_file\n" if $debug;

      # send .shar files with plain format
      $coding = "plain" if $format eq "Shell Archive";
      $coding = "plain" if $format eq "PostScript";

      $format .= " (" . int(($st_size+1023)/1024) . "K)";
      if ( $plist ) {
        $remarks = "Part";
	$remarks .= "s" if index ($plist, ",") >= 0;
	$remarks .= " $plist only";
      }

      # put the request in the batch queue
      if ( $nobatch ) {
	$entries++;
      } else {

# This was an attempt to get this to pass taintperl..
# if ($pid = open(CMD, "-|")) { exec "$nice", "$perl $lib/dorequest", "\'$path\'",
# "\'$the_file\'", "$coding", "$tmp[0]", "$plist"; print "exec failed!\n"; }
# if (defined($pid)) ....

	if (open(CMD,
	"$perl $lib/dorequest \'$path\' \'$the_file\' $coding $tmp[0] $plist |")) {
	  # Open completed OK
	  # Any output from dorequest means there was an error

	  while(<CMD>) {
	    $remarks = "Queue error: $_";
	    &syslog('warning', "dorequest printed: $_");
	  }
	  close (CMD);
	  if ( $? == 0 ) {
		  $entries++;
	  } elsif ($remarks eq "") {
	    &syslog('warning', "dorequest non-zero exit status: $_");
	    $remarks = "Queue error: cmd status";
	  }
	} else {
	  # Open of command failed.
	  $remarks = "Cannot queue: $!";
	  &syslog('warning', "Open of dorequest cmd: $!");
	}
      }
    }

    # put out the report line
    write;

    # end of pass thru @work
  }

  if ( $entries > 0 ) {
    print "\nWhen the load on the server permits, ";
    if ( $entries > 1 ) {
      print "these requests";
    } else {
      print "this request";
    }
    print " will be sent.\n";
  }
}

&showfile("$hints");
print "\nMail Server finished.\n";
close (stdout);

open(message, $tmpfile) || &logdie("$tmpfile went away: $!");
unlink $tmpfile;

if ( $debug ) {
  open (mailer, ">&stderr") || &logdie("open of stderr failed: $!");
} else {
  open (mailer, "| $howmail") || &logdie("open of \'$howmail\' failed: $!");
}

print mailer "To: $path\n";
print mailer "Subject: Your request\n";
print mailer "Bcc: $bcc\n" if $bcc;
print mailer "\n";
while ( <message> ) {
  print mailer $_;
}
close (mailer);
close (message);
unlink $tmpfile;
do closelog();
exit 0;

########  Subroutines

sub errmsg {
  local ($msg) = shift (@_);
  print ">>>>>>>> $msg\n";
  $errflag++;
}

sub help {
  if ($didhelp == 1) {
     print "Multiple help requests in the same message are ignored.\n";
  } else {
    &showfile("$shorthelp");
    $didhelp = 1;
  }
}

sub source {
    local($file) = @_;
    local($return) = 0;

    $return = do $file;
    &logdie("couldn't parse $file: $@") if $@;
    &logdie("couldn't do $file: $!") unless defined $return;
    &logdie("couldn't run $file") unless $return;
    $return;
} 

# Check to see if string contains any shell special chars.

sub chkspecial {
	local($line) = @_;

	$program = "";
	foreach $char (@special) {
		$program = $program .
			"\$badchar++ if index(\$line, \"$char\") >= $[;\n";
	}
	study($line);
	$badchar = 0;
	eval $program;

	if ($badchar) {
		print
"The requested <item> contains one or more of the following UNIX
shell special character(s): $special
Request rejected for security reasons.\n";
		return(1);
	} else {
		return(0);
	}
}

# Print the contents of filename contained in argument

sub showfile {
	local($FILE) = @_;

	if (open(FILE)) {
		while (<FILE>) {
			print $_;
		}
	} else {
		&dielog('Open of $FILE failed: $!');
	}
}

sub logdie {
	do syslog('alert', @_);
	do closelog();
	die;
}

# This gets called when either a bad command or return address 
# has been detected.  **Assumes stdout is still set to $tmpfile**

sub badmsg {
	local($msg) = @_;
	do syslog('INFO', "$msg");

	print "\n>> The rest of this message was ignored <<\n";

	while (do rfc822_not_eof()) {
		$res = do rfc822_read_header(1);
		print "$rfc822_line\n";
	}
	close (stdout);

	open(message, $tmpfile) || &logdie("$tmpfile went away: $!");
	unlink $tmpfile;

	open(mailer, "| $howmail") || &logdie("open of \'$howmail\' failed: $!");
	print mailer "To: $humanaddr\n";
	print mailer "Subject: $msg\n";
	print mailer "\nServer problem: $msg\nHere's the message...\n\n";
	while ( <message> ) {
		print mailer $_;
	}
	close(mailer);
	close(message);
	do closelog();
	exit 0;
}
