/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char *sccsid = "@(#)misc.c	1.2 (Ames) 12/10/87";
#endif not lint

#include "rcv.h"
#include <pwd.h>
#include <errno.h>
#include <syslog.h>

char	userbuf[16]	= "USER=";
char	homebuf[128]	= "HOME=";
extern char	**environ;
extern int	errno;
extern char	*sys_errlist[];
struct	passwd *pwd;

fold(argc, argv)
char **argv;
{
	int slen;
	char *folder;

	if (!logged_on) {
		printf("- Login with HELO first.\r\n");
		return (-1);
	}
	if (state == WAIT_FOR_ACK) {
		printf("- expecting ACKS, ACKD, or NACK\r\n");
		return (-1);
	}
	if (argc == 1)
		folder = def_folder;
	else
		folder = argv[1];
	if (setfile(folder, 1) < 0) {
		printf("#0 %s: %s\r\n", folder, sys_errlist[errno]);
		return (-1);
	}
	printf("#%d messages in %s\r\n", msgCount, mailname);
	return 0;
}

helo(argc, argv)
char **argv;
{
	int i;

	if (state == WAIT_FOR_ACK) {
		printf("- expecting ACKS, ACKD, or NACK\r\n");
		return (-1);
	}
	if (argc < 3) {
		printf("- Invalid arguments\r\n");
		return (-1);
	}
	if (check_user(argv[1], argv[2])) {
		return (-1);
	}
	if ((i = setfile(def_folder, 1)) < 0) {
		if (i == -1)
			printf("#0 %s: %s\r\n", def_folder, sys_errlist[errno]);
		else
			printf("#0 unknown error %d\r\n", i);
		return (-1);
	}
	printf("#%d messages in %s\r\n", msgCount, mailname);
	return 0;
}

char *crypt();
static char folder[PATHSIZE];

/* check out login information */
check_user (user, passwrd)
char *user, *passwrd;
{
	
	pwd = getpwnam(user);
	if (pwd == NULL) {
		printf("- Login incorrect.\r\n");
		return (-1);
	}

	if (strcmp(crypt(passwrd, pwd->pw_passwd), pwd->pw_passwd)) {
		printf("- Login incorrect.\r\n");
		return (-1);
	}

	/* got valid user here, become him... */
	setgid (pwd->pw_gid);
	initgroups(user, pwd->pw_gid);
	setuid (pwd->pw_uid);
	setenv("USER", pwd->pw_name, 1);
	setenv("HOME", pwd->pw_dir, 1);
	strcpy(homedir, pwd->pw_dir);
	(void)chdir(pwd->pw_dir);

	strcpy(folder, "/usr/spool/mail/");
	strcat(folder, pwd->pw_name);
	def_folder = folder;
	logged_on = 1;
	return(0) ;
}

name(argc, argv)
char **argv;
{
	struct passwd *pw;

	if (!logged_on && argc < 2) {
		printf("- Invalid arguments\r\n");
		return (-1);
	}
	if (argc < 2)
		pw = pwd;
	else
		pw = getpwnam(argv[1]);
	if (pw == NULL) {
		printf("- Unknown user\r\n");
		return (-1);
	}
	printf("%s\r\n", pw->pw_gecos);
	return 0;
}

dofrom(argc, argv)
char **argv;
{
	unixfrom = 1;
	printf("+ Will show unix From lines.\r\n");
}
