/*
pop3d.h 1.4 11/26/91
	Header file for the pop3 implementation.

	Written by W. Gregg Stefancik (wstef@eng.clemson.edu)
*/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#if defined(hpux)
#include <string.h>
#else
#include <strings.h>
#endif /* hpux */
#include <syslog.h>
#include <signal.h>
#include <sgtty.h>
#include <errno.h>

#include <varargs.h>
#include <pwd.h>

#include <netdb.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#if !defined(hpux)
#include <arpa/inet.h>
#endif /* hpux */

#include <sys/stat.h>

/* a few machine specifics */
#if defined(ultrix) || defined(bsd4_2)
#define OPENLOG(x,y,z)	openlog(x,y)
#define SECLOG_PRI	LOG_CRIT
#else
#define OPENLOG(x,y,z)	openlog(x,y,z)
#define SECLOG_PRI	LOG_NOTICE|LOG_AUTH
#endif

/* define the truth */
#define TRUE	1
#define FALSE	0

/* default pop-3 port */
#define DEFAULT_POP3_PORT 110

/* command parameter structure */
struct cmd_parms
{
  char *cmdp_str;	/* character string representing this command */
  int  cmdp_cmd;	/* token value for this command */
  int  cmdp_args;	/* number of arguments ( -1 -> 0 or 1 argument) */
  int  cmdp_atype;	/* type of argument */
};

/* define state values */
#define AUTH_STATE	0
#define TRANS_STATE	1
#define UPDATE_STATE	2

extern int server_state;

/* define command values */
#define BAD_CMD		0
#define USER_CMD	1
#define PASS_CMD	2
#define STAT_CMD	3
#define LIST_CMD	4
#define RETR_CMD	5
#define DELE_CMD	6
#define NOOP_CMD	7
#define LAST_CMD	8
#define RSET_CMD	9
#define RPOP_CMD	10
#define TOP_CMD		11
#define QUIT_CMD	12

/* argument types */
#define CMDAT_NUL	0
#define CMDAT_STR	1
#define CMDAT_NUM	2

struct mail_ent
{
  int me_msg_id;		/* message id number */
  int me_status;		/* new, read, old, or deleted */
  long me_start_pos;		/* start of this mail message */
  long me_length;		/* length of this mail message */
  struct mail_ent *me_prev;	/* pointer to prev mail message entry */
  struct mail_ent *me_next;	/* pointer to next mail message entry */
};

/* mail status masks */
#define MST_NEW		0x00
#define MST_READ	0x01
#define MST_OLD		0x02
#define MST_DELETE	0x04

extern char version[];
extern char *tmp_mbox_name;
extern int con_sock, tmp_mbox_fd, debug;
extern FILE *con_stream;

extern int total_msgs, last_msg_rd, cur_msgs;
extern long cur_size;

/* function definitions*/
char *get_line(), *malloc();
#ifdef hp300
extern char *tempnam();
#endif

#define unlock_spool_mail(x) unlink(mail_lock_name)
